/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.config;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.dreceiptx.config.Region;
import net.dreceiptx.receipt.common.Country;
import net.dreceiptx.receipt.common.Currency;
import net.dreceiptx.receipt.common.Language;
import net.dreceiptx.receipt.tax.TaxCode;

public enum Location {
    Australia("AUS", Country.Australia, Currency.AustralianDollar, Region.Australasia, TaxCode.GoodsAndServicesTax, Language.English, TimeZone.getTimeZone("Australia/Sydney")),
    Canada("CAN", Country.Canada, Currency.CanadianDollar, Region.Canada, TaxCode.GoodsAndServicesTax, Language.English, TimeZone.getTimeZone("Canada/Eastern")),
    France("FRA", Country.France, Currency.Euro, Region.EuroWest, TaxCode.ValueAddedTax, Language.French, TimeZone.getTimeZone("Europe/Paris")),
    Ireland("IRE", Country.Ireland, Currency.Euro, Region.EuroWest, TaxCode.ValueAddedTax, Language.English, TimeZone.getTimeZone("Europe/Dublin")),
    NewZealand("NZL", Country.NewZealand, Currency.NewZealandDollar, Region.Australasia, TaxCode.GoodsAndServicesTax, Language.English, TimeZone.getTimeZone("NZ")),
    UnitedKingdom("GBR", Country.UnitedKingdom, Currency.BritishSterling, Region.EuroWest, TaxCode.ValueAddedTax, Language.English, TimeZone.getTimeZone("Europe/London")),
    USEastCoast("USEastCoast", Country.UnitedStatesOfAmerica, Currency.USDollar, Region.USEast, TaxCode.ValueAddedTax, Language.English, TimeZone.getTimeZone("America/New_York")),
    USWestCoast("USWestCoast", Country.UnitedStatesOfAmerica, Currency.USDollar, Region.USWest, TaxCode.ValueAddedTax, Language.English, TimeZone.getTimeZone("America/Los_Angeles"));

    private String _code;
    private Country _country;
    private Currency _currency;
    private TaxCode _salesTaxCode;
    private Region _region;
    private Language _language;
    private TimeZone _timeZone;
    private static Map<String, Location> enums;

    private Location(String code, Country country, Currency name, Region region, TaxCode salesTaxCode, Language language, TimeZone timeZone) {
        this._code = code;
        this._country = country;
        this._currency = name;
        this._region = region;
        this._salesTaxCode = salesTaxCode;
        this._language = language;
        this._timeZone = timeZone;
    }

    public String getCode() {
        return this._code;
    }

    public Country getCountry() {
        return this._country;
    }

    public Currency getCurrency() {
        return this._currency;
    }

    public Region getRegion() {
        return this._region;
    }

    public TaxCode getGoodsAndServicesTaxCode() {
        return this._salesTaxCode;
    }

    public Language getLanguage() {
        return this._language;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public String toString() {
        return this._code;
    }

    private Location(String code) {
        this._code = code;
    }

    public static Location codeOf(String code) {
        return enums.get(code);
    }

    static {
        enums = new HashMap<String, Location>();
        for (Location country : Location.values()) {
            enums.put(country._code, country);
        }
    }
}

