/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.merchant;

import com.google.gson.annotations.SerializedName;
import java.util.List;

public class Merchant {
    @SerializedName("id") private String _id;
    @SerializedName("industry") private String _industry;
    @SerializedName("sector") private String _sector;
    @SerializedName("fullName") private String _fullName;
    @SerializedName("commonName") private String _commonName;
    @SerializedName("businessTaxNumber") private String _businessTaxNumber;
    @SerializedName("businessTaxNumberType") private String _businessTaxNumberType;
    @SerializedName("businessRegistrationNumber") private String _businessRegistrationNumber;
    @SerializedName("primaryPhone") private String _primaryPhone;
    @SerializedName("primaryAddress") private MerchantAddress _primaryAddress;
    @SerializedName("primaryEmail") private String _primaryEmail;
    @SerializedName("website") private String _website;
    @SerializedName("contacts") private List<MerchantContact> _contacts;
    @SerializedName("status") private MerchantStatus _status = MerchantStatus.Active;
    private transient String _merchantLocationHostname = "https://merchants.dreceiptx.net/location/";

    public String getId() {
        return _id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getIndustry() {
        return _industry;
    }

    public void setIndustry(String industry) {
        this._industry = industry;
    }

    public String getSector() {
        return _sector;
    }

    public void setSector(String _sector) {
        this._sector = _sector;
    }

    public String getFullName() {
        return _fullName;
    }

    public void setFullName(String fullName) {
        this._fullName = fullName;
    }

    public String getCommonName() {
        return _commonName;
    }

    public void setCommonName(String commonName) {
        this._commonName = commonName;
    }

    public String getBusinessTaxNumber() {
        return _businessTaxNumber;
    }

    public void setBusinessTaxNumber(String businessTaxNumber) {
        this._businessTaxNumber = businessTaxNumber;
    }

    public String getBusinessTaxNumberType() {
        return _businessTaxNumberType;
    }

    public void setBusinessTaxNumberType(String businessTaxNumberType) {
        this._businessTaxNumberType = businessTaxNumberType;
    }

    public String getBusinessRegistrationNumber() {
        return _businessRegistrationNumber;
    }

    public void setBusinessRegistrationNumber(String businessRegistrationNumber) {
        this._businessRegistrationNumber = businessRegistrationNumber;
    }

    public String getPrimaryPhone() {
        return _primaryPhone;
    }

    public void setPrimaryPhone(String primaryPhone) {
        this._primaryPhone = primaryPhone;
    }

    public String getPrimaryEmail() {
        return _primaryEmail;
    }

    public void setPrimaryEmail(String primaryEmail) {
        this._primaryEmail = primaryEmail;
    }

    public String getWebsite() {
        return _website;
    }

    public void setWebsite(String website) {
        this._website = website;
    }

    public MerchantAddress getPrimaryAddress() {
        return _primaryAddress;
    }

    public void setPrimaryAddress(MerchantAddress primaryAddress) {
        this._primaryAddress = primaryAddress;
    }

    public List<MerchantContact> getContacts() {
        return _contacts;
    }

    public void setContacts(List<MerchantContact> contacts) {
        this._contacts = contacts;
    }

    public void setMerchantLocationHostname(String merchantLocationHostname) {
        this._merchantLocationHostname = merchantLocationHostname;
    }

    public String getMerchantLocationHostname() {
        return _merchantLocationHostname;
    }

    public String getMerchantLogoUrl(){
        return _merchantLocationHostname+_id+"/logo.jpg";
    }

    public MerchantStatus getStatus() {
        return _status;
    }

    public void setStatus(MerchantStatus status) {
        this._status = status;
    }
}
