/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.entertainment;

import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;

public class Entertainment extends LineItem {
    public static final String LineItemTypeValue = "ENT0001";

    public Entertainment(EntertainmentType entertainmentType, String provider, String shortDescription, String longDescription, int quantity, double price) {
        super(provider, shortDescription, longDescription, quantity, price);
        this.setTradeItemGroupIdentificationCode(entertainmentType.code());
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Entertainment.LineItemTypeValue);
    }

    public Entertainment(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this(tradeItemDescriptionInformation, (double)quantity, price);
    }

    public Entertainment(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Entertainment.LineItemTypeValue);
    }
    
    public String getServiceProviderName(){
        return this.getBrandName();
    }

    public void setIncludesAlcohol(boolean includesAlcohol){
        this._AVPList.add(AVPType.INCLUDES_ALCOHOL.Code(), String.valueOf(includesAlcohol));
    }

    public Boolean getIncludesAlcohol(){
        try{
            return Boolean.valueOf(this._AVPList.get(AVPType.INCLUDES_ALCOHOL.Code()).getValue());
        }catch (Exception e){
            return null;
        }
    }

    public String getShortDescription(){
        return this.getName();
    }

    public String getDetailedDescription(){
        return this.getDescription();
    }
    
    public EntertainmentType getEntertainmentType(){
        return (EntertainmentType)this.getLineItemType(EntertainmentType.class, EntertainmentType.Standard);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}