/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.common;

import com.google.gson.annotations.SerializedName;

import java.util.HashMap;
import java.util.Map;

public enum Country {
    @SerializedName("AUS")
    Australia("AUS", "Australia"),
    @SerializedName("CAN")
    Canada("CAN", "Canada"),
    @SerializedName("FRA")
    France("FRA", "France"),
    @SerializedName("IRE")
    Ireland("IRE", "Ireland"),
    @SerializedName("NZL")
    NewZealand("NZL", "NewZealand"),
    @SerializedName("GBR")
    UnitedKingdom("GBR", "UnitedKingdom"),
    @SerializedName("USA")
    UnitedStatesOfAmerica("USA", "UnitedStatesOfAmerica");

    private String _code;

    private String _displayName;

    private static Map<String, Country> enums = new HashMap<String, Country>();

    static {
        for (Country country : Country.values()) {
            enums.put(country._code, country);
        }
    }

    Country(String code, String name) {
        _code = code;
        _displayName = name;
    }

    public String getCode() {
        return _code;
    }

    public String getDisplayName() {
        return _displayName;
    }

    @Override
    public String toString() {
        return _displayName;
    }

    private Country(final String countryCode) { _code = countryCode; }

    public static Country codeOf(String countryCode) {
        if(!enums.containsKey(countryCode)){
            throw new RuntimeException("Unknown Country Code ["+countryCode+"] supplied, please supply a valid and supported Country");
        }
        return enums.get(countryCode);
    }
}
