/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.config;

import com.google.gson.annotations.SerializedName;
import net.dreceiptx.receipt.common.Currency;

import java.util.HashMap;
import java.util.Map;

public enum Region {
    @SerializedName("AUS")
    Australasia("AUS",
            "9377778071234",
            "https://aus-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("APC")
    AsiaPacificCentral("APC",
            "9377778071234",
            "https://apc-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("CAN")
    Canada("CAN",
            "9377778071234",
            "https://can-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("EUE")
    EuroEast("EUE",
            "9377778071234",
            "https://eue-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("EUW")
    EuroWest("EUW",
            "9377778071234",
            "https://euw-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("USE")
    USEast("USE",
            "9377778071234",
            "https://use-api.dreceiptx.net",
            "https://directory.dreceiptx.net"),
    @SerializedName("USW")
    USWest("USW",
            "9377778071234",
            "https://usw-api.dreceiptx.net",
            "https://directory.dreceiptx.net");

    private String _code;

    private String _gln;

    private String _apiEndpoint;

    private String _directoryEndpoint;

    private static Map<String, Region> enums = new HashMap<String, Region>();

    static {
        for (Region region : Region.values()) {
            enums.put(region._code, region);
        }
    }

    Region(String code, String gln, String apiEndpoint, String directoryEndpoint) {
        _code = code;
        _gln = gln;
        _apiEndpoint = apiEndpoint;
        _directoryEndpoint = directoryEndpoint;
    }

    public String getCode() {
        return _code;
    }

    public String getGLN() {
        return _gln;
    }

    public String getAPIEndpoint() {
        return _apiEndpoint;
    }

    public String getDirectoryEndpoint() {
        return _directoryEndpoint;
    }

    @Override
    public String toString() {
        return _code;
    }

    private Region(final String code) { _code = code; }

    public static Region codeOf(String code) {
        return enums.get(code);
    }
}
