/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.dreceiptx.receipt.invoice.Invoice;
import net.dreceiptx.receipt.lineitem.LineItem;

public class DigitalReceiptDeserializer
implements JsonDeserializer<Invoice> {
    public Invoice deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        JsonObject invoiceObject = (JsonObject)json;
        try {
            Invoice invoice = new Invoice();
            invoice.setCreationDateTime(dateFormatter.parse(invoiceObject.get("creationDateTime").getAsString()));
            invoice.setInvoiceCurrencyCode(invoiceObject.get("invoiceCurrencyCode").getAsString());
            invoice.setCountryOfSupplyOfGoods(invoiceObject.get("countryOfSupplyOfGoods").getAsString());
            Type listType = new TypeToken<ArrayList<LineItem>>(){}.getType();
            List lineItems = (List)new Gson().fromJson((JsonElement)invoiceObject.get("invoiceLineItem").getAsJsonObject(), listType);
            invoice.setInvoiceLineItems(lineItems);
            return invoice;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

