/*
 * Decompiled with CFR 0.152.
 */
package net.dreceiptx.receipt.lineitem.general;

import java.math.BigDecimal;
import net.dreceiptx.receipt.lineitem.LineItem;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;

public class Book
extends LineItem {
    public static final String LineItemTypeValue = "GENERAL0001";
    private final String _tradeItemIdentificationISBN = "ISBN";

    public Book(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this(tradeItemDescriptionInformation, (double)quantity, price);
    }

    public Book(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
    }

    public Book(String ISBN, int quantity, double price) {
        this.addTradeItemIdentification("DRX_LINEITEM_TYPE", LineItemTypeValue);
        this.addTradeItemIdentification("ISBN", ISBN);
        this._quantity = BigDecimal.valueOf(quantity);
        this._price = BigDecimal.valueOf(price);
    }

    public String getIBSNNumber() {
        return this.getTradeItemIdentificationValue("ISBN");
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}

