/*
 * Copyright 2016 Digital Receipt Exchange Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreceiptx.receipt.lineitem.travel;

import net.dreceiptx.receipt.ecom.AVPType;
import net.dreceiptx.receipt.lineitem.TradeItemDescriptionInformation;
import net.dreceiptx.receipt.lineitem.TransactionalTradeItemType;
import net.dreceiptx.receipt.lineitem.LineItem;

import java.util.Date;

public class Accommodation extends LineItem {
    public static final String LineItemTypeValue = "TRAVEL0001";

    public Accommodation(AccommodationType accommodationType, String provider, String shortDescription, String longDescription, int nights, double rate) {
        super(provider, shortDescription, longDescription, nights, rate);
        this.setTradeItemGroupIdentificationCode(accommodationType.code());
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Accommodation.LineItemTypeValue);
    }

    public Accommodation(TradeItemDescriptionInformation tradeItemDescriptionInformation, int quantity, double price) {
        this(tradeItemDescriptionInformation, (double)quantity, price);
    }

    public Accommodation(TradeItemDescriptionInformation tradeItemDescriptionInformation, double quantity, double price) {
        super(tradeItemDescriptionInformation, quantity, price);
        this._transactionalTradeItemType = TransactionalTradeItemType.MANUAL;
        this.addTradeItemIdentification(LineItem.LineItemTypeIdentifier, Accommodation.LineItemTypeValue);
    }
    
    public String getProviderName(){
        return this.getBrandName();
    }

    public String getShortDescription(){
        return this.getName();
    }

    public String getDetailedDescription(){
        return this.getDescription();
    }
    
    public AccommodationType getAccommodationType(){
        return (AccommodationType)this.getLineItemType(AccommodationType.class, AccommodationType.DEFAULT);
    }

    public void setPassengerName(String passengerName){
        this._AVPList.add(AVPType.PASSENGER_NAME.Code(), passengerName);
    }

    public Date getDepartureDate(){
        return this.getDespatchDate();
    }

    public void setDepartureDate(Date departureDate){
        this.setDespatchDate(departureDate);
    }

    public Date getArrivalDate(){
        return this.getDeliveryDate();
    }

    public void setArrivalDate(Date arrivalDate){
        this.setDeliveryDate(arrivalDate);
    }

    @Override
    public String getLineItemTypeValue() {
        return LineItemTypeValue;
    }
}