
package net.dreceiptx.receipt.common.Measurement;

import com.google.gson.annotations.SerializedName;

public enum MeasurementType {
    @SerializedName("MMT")
    MILLIMETRE("MMT", "mm"),
    @SerializedName("CMT")
    CENTIMETRE("CMT", "cm"),
    @SerializedName("FOT")
    FOOT("FOT", "ft"),
    @SerializedName("YRD")
    YARD("YRD", "yd"),
    @SerializedName("MTQ")
    CUBIC_METRE("MTQ", "m3"),
    @SerializedName("LTR")
    LITRE("LTR", "l"),
    @SerializedName("GLI")
    GALLOON_UK("GLI", "gal (UK)"),
    @SerializedName("GLL")
    GALLOON_US("GLL", "gal (US)"),
    @SerializedName("TNE")
    TON_METRIC("TNE", "t"),
    @SerializedName("KGM")
    KILOGRAM("KGM", "kg"),
    @SerializedName("MGM")
    MILLIGRAM("MGM", "mg"),
    @SerializedName("LBR")
    POUND("LBR", "lb");

    private String _value;

    private String _displayName;

    MeasurementType(String value, String name) {
        _value = value;
        _displayName = name;
    }

    public String getValue() {
        return _value;
    }

    public String getDisplayName() {
        return _displayName;
    }

    @Override
    public String toString() {
        return _displayName;
    }
}
