/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client.httpclient;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.RequestLine;
import org.tio.utils.SysConst;

public class HttpRequestEncoder {
    private static Logger log = LoggerFactory.getLogger(HttpRequestEncoder.class);

    public static ByteBuffer encode(HttpRequest httpRequest, TioConfig tioConfig, ChannelContext channelContext) throws UnsupportedEncodingException {
        int bodyLength = 0;
        byte[] body = httpRequest.getBody();
        if (body != null) {
            bodyLength = body.length;
        }
        if (bodyLength > 0) {
            httpRequest.addHeader("content-length", Integer.toString(bodyLength));
        }
        RequestLine requestLine = httpRequest.getRequestLine();
        byte[] requestLineBytes = requestLine.toUrlEncodedString(httpRequest.getCharset()).getBytes();
        Map headers = httpRequest.getHeaders();
        StringBuilder sb = new StringBuilder(headers.size() * 50);
        Set headersEntry = headers.entrySet();
        for (Map.Entry entry : headersEntry) {
            sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\r\n");
        }
        byte[] headerBytes = sb.toString().getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(requestLineBytes.length + 2 + headerBytes.length + 2 + bodyLength);
        buffer.put(requestLineBytes);
        buffer.put(SysConst.CR_LF);
        buffer.put(headerBytes);
        buffer.put(SysConst.CR_LF);
        if (bodyLength > 0) {
            buffer.put(body);
        }
        buffer.flip();
        return buffer;
    }

    private HttpRequestEncoder() {
    }
}

