/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client;

import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.intf.TioClientListener;
import org.tio.websocket.client.WebSocket;
import org.tio.websocket.client.WebSocketImpl;
import org.tio.websocket.client.WsTioClientHander;
import org.tio.websocket.client.WsTioClientListener;
import org.tio.websocket.client.config.WsClientConfig;
import org.tio.websocket.client.kit.ReflectKit;
import org.tio.websocket.client.kit.UriKit;

public class WsClient {
    private static Logger log = LoggerFactory.getLogger(WsClient.class);
    static TioClientHandler tioClientHandler = new WsTioClientHander();
    static TioClientListener tioListener = new WsTioClientListener();
    URI uri;
    String rawUri;
    TioClient tioClient;
    WsClientConfig config = new WsClientConfig();
    ClientChannelContext clientChannelContext;
    Map<String, String> additionalHttpHeaders;
    WebSocketImpl ws;
    TioClientConfig tioClientConfig;

    public static WsClient create(String uri) throws Exception {
        return WsClient.create(uri, (Map<String, String>)null);
    }

    public static WsClient create(String uri, Map<String, String> additionalHttpHeaders) throws Exception {
        return new WsClient(uri, additionalHttpHeaders);
    }

    public static WsClient create(String uri, WsClientConfig config) throws Exception {
        return WsClient.create(uri, null, config);
    }

    public static WsClient create(String uri, Map<String, String> additionalHttpHeaders, WsClientConfig config) throws Exception {
        WsClient client = new WsClient(uri, additionalHttpHeaders);
        client.config = config;
        return client;
    }

    WsClient(String rawUri) throws Exception {
        this(rawUri, null);
    }

    WsClient(String rawUri, Map<String, String> additionalHttpHeaders) throws Exception {
        rawUri = rawUri.trim();
        if (!rawUri.matches("wss?\\://((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])|(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))(\\:[0-9]+)?(/.*)?(\\?.*)?")) {
            throw new Exception("Invalid uri of " + rawUri);
        }
        this.rawUri = rawUri;
        this.additionalHttpHeaders = additionalHttpHeaders;
        this.construct();
    }

    public synchronized WebSocket connect() throws Exception {
        this.ws.connect();
        return this.ws;
    }

    public void close() {
        if (this.ws != null) {
            this.ws.close();
            this.ws = null;
            this.clientChannelContext = null;
            this.tioClientConfig = null;
            this.tioClient = null;
        }
    }

    public WebSocket getWs() {
        return this.ws;
    }

    public WsClientConfig getConfig() {
        return this.config;
    }

    public TioClient getTioClient() {
        return this.tioClient;
    }

    public ClientChannelContext getClientChannelContext() {
        return this.clientChannelContext;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getRawUri() {
        return this.rawUri;
    }

    void construct() throws Exception {
        this.uri = UriKit.parseURI(this.rawUri);
        int port = this.uri.getPort();
        if (port == -1) {
            if (this.uri.getScheme().equals("ws")) {
                port = 80;
                log.info("No port specified, use the default: {}", (Object)port);
            } else {
                port = 443;
            }
            try {
                ReflectKit.setField(this.uri, "port", port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tioClientConfig = new TioClientConfig(tioClientHandler, tioListener, null);
        this.tioClientConfig.setHeartbeatTimeout(0L);
        if (this.uri.getScheme().equals("ws")) {
            this.tioClient = new TioClient(this.tioClientConfig);
        } else {
            this.tioClientConfig.useSsl();
            this.tioClient = new TioClient(this.tioClientConfig);
        }
        this.ws = new WebSocketImpl(this, this.additionalHttpHeaders);
    }
}

