/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client;

import io.reactivex.Observable;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.tio.websocket.client.event.CloseEvent;
import org.tio.websocket.client.event.ErrorEvent;
import org.tio.websocket.client.event.MessageEvent;
import org.tio.websocket.client.event.OpenEvent;
import org.tio.websocket.common.WsPacket;
import org.tio.websocket.common.WsRequest;

public interface WebSocket {
    public static final int CONNECTING = 0;
    public static final int OPEN = 1;
    public static final int CLOSING = 2;
    public static final int CLOSED = 3;

    public String getExtensions();

    public Runnable addOnClose(Consumer<CloseEvent> var1);

    public Runnable addOnError(Consumer<ErrorEvent> var1);

    public Runnable addOnMessage(Consumer<MessageEvent> var1);

    public Runnable addOnOpen(Consumer<OpenEvent> var1);

    public Runnable addOnThrows(Consumer<Throwable> var1);

    public String getProtocol();

    public int getReadyState();

    public String getUrl();

    public void connect() throws Exception;

    default public void close() {
        this.close(1000);
    }

    default public void close(int code) {
        this.close(code, "");
    }

    public void close(int var1, String var2);

    default public void send(byte[] data) {
        this.send((WsPacket)WsRequest.fromBytes((byte[])data));
    }

    default public void send(ByteBuffer data) {
        if (data.hasArray()) {
            this.send(data.array());
        } else {
            int remaining = data.remaining();
            byte[] bytes = new byte[remaining];
            data.get(bytes);
            this.send(bytes);
        }
    }

    public void send(String var1);

    public void send(WsPacket var1);

    public Observable<WsPacket> getMessageStream();
}

