/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/
	
	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
	
	1. Definitions.
	
	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.
	
	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.
	
	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.
	
	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.
	
	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.
	
	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.
	
	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).
	
	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.
	
	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."
	
	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.
	
	2. Grant of Copyright License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.
	
	3. Grant of Patent License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.
	
	4. Redistribution.
	
	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:
	
	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.
	
	5. Submission of Contributions.
	
	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.
	
	6. Trademarks.
	
	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.
	
	7. Disclaimer of Warranty.
	
	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.
	
	8. Limitation of Liability.
	
	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.
	
	9. Accepting Warranty or Additional Liability.
	
	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.
	
	END OF TERMS AND CONDITIONS
	
	APPENDIX: How to apply the Apache License to your work
	
	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.
	
	   Copyright 2020 t-io
	
	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at
	
	     http://www.apache.org/licenses/LICENSE-2.0
	
	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.http.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.TcpConst;
import org.tio.http.common.TioConfigKey;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import org.tio.server.TioServerConfig;
import org.tio.server.TioServer;
import org.tio.utils.Threads;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.hutool.FileUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

import okhttp3.Response;

/**
 *
 * @author tanyaowu
 */
public class HttpServerStarter {
	private static Logger			log						= LoggerFactory.getLogger(HttpServerStarter.class);
	private HttpConfig				httpConfig				= null;
	private HttpTioServerHandler	httpTioServerHandler	= null;
	private HttpTioServerListener	httpTioServerListener	= null;
	private TioServerConfig		tioServerConfig		= null;
	private TioServer				tioServer				= null;
	private HttpRequestHandler		httpRequestHandler		= null;
	/**
	 * 预访问路径的后缀
	 */
	private List<String>			preAccessFileType		= new ArrayList<>();

	/**
	 * 
	 * @param httpConfig
	 * @param requestHandler
	 * @author tanyaowu
	 */
	public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
		this(httpConfig, requestHandler, null, null);
	}

	/**
	 * 
	 * @param httpConfig
	 * @param requestHandler
	 * @param tioExecutor
	 * @param groupExecutor
	 * @author tanyaowu
	 */
	public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
		//		preAccessFileType.add("css");
		//		preAccessFileType.add("js");
		//		preAccessFileType.add("jsp");
		preAccessFileType.add("html");
		preAccessFileType.add("ftl");
		//		preAccessFileType.add("xml");
		//		preAccessFileType.add("htm");

		if (tioExecutor == null) {
			tioExecutor = Threads.getTioExecutor();
		}

		if (groupExecutor == null) {
			groupExecutor = Threads.getGroupExecutor();
		}

		init(httpConfig, requestHandler, tioExecutor, groupExecutor);
	}

	//	/**
	//	 * @deprecated
	//	 * @param pageRoot 如果为null，则不提供静态资源服务
	//	 * @param serverPort
	//	 * @param contextPath
	//	 * @param scanPackages
	//	 * @param httpServerInterceptor
	//	 * @author tanyaowu
	//	 * @throws IOException 
	//	 */
	//	public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor) throws IOException {
	//		this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, null, null, null);
	//	}
	//
	//	/**
	//	 * @deprecated
	//	 * @param pageRoot 如果为null，则不提供静态资源服务
	//	 * @param serverPort
	//	 * @param contextPath
	//	 * @param scanPackages
	//	 * @param httpServerInterceptor
	//	 * @param sessionStore
	//	 * @author tanyaowu
	//	 * @throws IOException 
	//	 */
	//	public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, ICache sessionStore) throws IOException {
	//		this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, sessionStore, null, null);
	//	}
	//
	//	/**
	//	 * @deprecated
	//	 * pageRoot 如果为null，则不提供静态资源服务
	//	 * @param pageRoot
	//	 * @param serverPort
	//	 * @param contextPath
	//	 * @param scanPackages
	//	 * @param httpServerInterceptor
	//	 * @param sessionStore
	//	 * @param tioExecutor
	//	 * @param groupExecutor
	//	 * @author tanyaowu
	//	 * @throws IOException 
	//	 */
	//	public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, ICache sessionStore,
	//			SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
	//		this(pageRoot, serverPort, contextPath, scanPackages, httpServerInterceptor, null, sessionStore, tioExecutor, groupExecutor);
	//	}
	//	
	//	/**
	//	 * @deprecated
	//	 * pageRoot 如果为null，则不提供静态资源服务
	//	 * @param pageRoot
	//	 * @param serverPort
	//	 * @param contextPath
	//	 * @param scanPackages
	//	 * @param httpServerInterceptor
	//	 * @param httpSessionListener
	//	 * @param sessionStore
	//	 * @param tioExecutor
	//	 * @param groupExecutor
	//	 * @author tanyaowu
	//	 * @throws IOException 
	//	 */
	//	public HttpServerStarter(String pageRoot, int serverPort, String contextPath, String[] scanPackages, HttpServerInterceptor httpServerInterceptor, HttpSessionListener httpSessionListener, ICache sessionStore,
	//			SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
	//		int port = serverPort;
	//
	//		httpConfig = new HttpConfig(port, null, contextPath, null);
	//		httpConfig.setPageRoot(pageRoot);
	//		if (sessionStore != null) {
	//			httpConfig.setSessionStore(sessionStore);
	//		}
	//
	//		Routes routes = new Routes(scanPackages);
	//		DefaultHttpRequestHandler requestHandler = new DefaultHttpRequestHandler(httpConfig, routes);
	//		requestHandler.setHttpServerInterceptor(httpServerInterceptor);
	//		requestHandler.setHttpSessionListener(httpSessionListener);
	//
	//		
	//		
	//		init(httpConfig, requestHandler, tioExecutor, groupExecutor);
	//	}

	/**
	 * @return the httpConfig
	 */
	public HttpConfig getHttpConfig() {
		return httpConfig;
	}

	public HttpRequestHandler getHttpRequestHandler() {
		return httpRequestHandler;
	}

	/**
	 * @return the httpTioServerHandler
	 */
	public HttpTioServerHandler getHttpTioServerHandler() {
		return httpTioServerHandler;
	}

	/**
	 * @return the httpTioServerListener
	 */
	public HttpTioServerListener getHttpTioServerListener() {
		return httpTioServerListener;
	}

	/**
	 * @return the tioServerConfig
	 */
	public TioServerConfig getTioServerConfig() {
		return tioServerConfig;
	}

	private void init(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
		String system_timer_period = System.getProperty("tio.system.timer.period");
		if (StrUtil.isBlank(system_timer_period)) {
			System.setProperty("tio.system.timer.period", "50");
		}

		this.httpConfig = httpConfig;
		this.httpRequestHandler = requestHandler;
		httpConfig.setHttpRequestHandler(this.httpRequestHandler);
		this.httpTioServerHandler = new HttpTioServerHandler(httpConfig, requestHandler);
		httpTioServerListener = new HttpTioServerListener();
		String name = httpConfig.getName();
		if (StrUtil.isBlank(name)) {
			name = "Tio Http Server";
		}
		tioServerConfig = new TioServerConfig(name, httpTioServerHandler, httpTioServerListener, tioExecutor, groupExecutor);
		tioServerConfig.setHeartbeatTimeout(1000 * 20);
		tioServerConfig.setShortConnection(true);
		tioServerConfig.setReadBufferSize(TcpConst.MAX_DATA_LENGTH);
		//		tioServerConfig.setAttribute(TioConfigKey.HTTP_SERVER_CONFIG, httpConfig);
		tioServerConfig.setAttribute(TioConfigKey.HTTP_REQ_HANDLER, this.httpRequestHandler);

		tioServer = new TioServer(tioServerConfig);

		HttpUuid imTioUuid = new HttpUuid();
		tioServerConfig.setTioUuid(imTioUuid);
	}

	public void setHttpRequestHandler(HttpRequestHandler requestHandler) {
		this.httpRequestHandler = requestHandler;
	}

	public void start() throws IOException {
		start(false);
	}

	/**
	 * @param preAccess
	 * @throws IOException
	 * @author tanyaowu
	 */
	public void start(boolean preAccess) throws IOException {
		if (httpConfig.isUseSession()) {
			if (httpConfig.getSessionStore() == null) {
				CaffeineCache caffeineCache = CaffeineCache.register(httpConfig.getSessionCacheName(), null, httpConfig.getSessionTimeout());
				httpConfig.setSessionStore(caffeineCache);
			}

			if (httpConfig.getSessionIdGenerator() == null) {
				httpConfig.setSessionIdGenerator(UUIDSessionIdGenerator.instance);
			}
		}

		tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort());

		if (preAccess) {
			preAccess();
		}
	}

	/**
	 * 预访问第一版功能先上，后面再优化
	 * 
	 * @author tanyaowu
	 */
	public void preAccess() {
		if (httpConfig.isPageInClasspath()) {
			log.info("暂时只支持目录形式的预访问");
			return;
		}

		String pageRoot = httpConfig.getPageRoot();
		if (pageRoot == null) {
			return;
		}

		new Thread(new Runnable() {
			@Override
			public void run() {
				Map<String, Long> pathCostMap = new TreeMap<>();

				long start = System.currentTimeMillis();
				preAccess(pageRoot, pathCostMap);
				long end = System.currentTimeMillis();
				long iv = end - start;

				Map<Long, Set<String>> costPathsMap = new TreeMap<>(new Comparator<Long>() {
					@Override
					public int compare(Long o1, Long o2) {
						//倒序排序
						return Long.compare(o2, o1);
					}
				});
				Set<Entry<String, Long>> entrySet = pathCostMap.entrySet();
				for (Entry<String, Long> entry : entrySet) {
					try {
						Long cost = entry.getValue();
						String path = entry.getKey();
						Set<String> pathSet = costPathsMap.get(cost);
						if (pathSet == null) {
							pathSet = new TreeSet<>();
							costPathsMap.put(cost, pathSet);
						}
						boolean added = pathSet.add(path);
						if (!added) {
							log.error("可能重复访问了:{}", path);
						}
					} catch (Exception e) {
						log.error(e.toString(), e);
					}
				}

				log.info("预访问了{}个path，耗时:{}ms，访问详情:\r\n{}\r\n耗时排序:\r\n{}", pathCostMap.size(), iv, Json.toFormatedJson(pathCostMap), Json.toFormatedJson(costPathsMap));
			}
		}).start();

	}

	/**
	 * 预访问第一版功能先上，后面再优化
	 * 
	 * @author tanyaowu
	 */
	private void preAccess(String rootpath, Map<String, Long> pathCostMap) {
		try {
			Map<String, String> headerMap = new HashMap<>();
			headerMap.put(HttpConst.RequestHeaderKey.Host, "127.0.0.1");

			String protocol = null;

			if (tioServerConfig.isSsl()) {
				protocol = "https";
			} else {
				protocol = "http";
			}
			String completePathPrefix = protocol + "://127.0.0.1:" + httpConfig.getBindPort();

			File rootDir = new File(rootpath);
			File[] files = rootDir.listFiles(new FileFilter() {
				@Override
				public boolean accept(File file) {
					//					String absolutePath = file.getAbsolutePath();
					String filename = file.getName();
					String extension = FileUtil.extName(filename);//.getExtension(filename);
					if (file.isDirectory()) {
						if ("svn-base".equalsIgnoreCase(extension)) {
							return false;
						}
						return true;
					}

					String ext = FileUtil.extName(file);
					if (preAccessFileType.contains(ext)) {
						return true;
					}
					return false;
				}
			});

			File pageRootFile = new File(httpConfig.getPageRoot());
			String pageRootAbs = pageRootFile.getCanonicalPath();
			for (File file : files) {
				try {
					if (file.isDirectory()) {
						preAccess(file.getCanonicalPath(), pathCostMap);
					} else {
						String absPath = file.getCanonicalPath();
						log.info("pageRoot:{}, 预访问路径getAbsolutePath:{}", httpConfig.getPageRoot(), absPath);
						long start = System.currentTimeMillis();
						String path = absPath.substring(pageRootAbs.length());

						if (!(path.startsWith("/") || path.startsWith("\\"))) {
							path = "/" + path;
						}
						log.info("预访问路径:{}", path);
						String url = completePathPrefix + path;
						Response response = HttpUtils.get(url, headerMap);
						long end = System.currentTimeMillis();
						long iv = end - start;
						pathCostMap.put(path, iv);
						log.info("预访问完成，耗时{}ms, [{}], {}", iv, path, response);
						response.close();
					}
				} catch (Exception e) {
					log.error(e.toString());
				}
			}
		} catch (Exception e) {
			log.error("预访问报错", e);
		}
	}

	public void stop() throws IOException {
		tioServer.stop();
	}

	public TioServer getTioServer() {
		return tioServer;
	}

}
