/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server.handler;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.server.handler.DefaultHttpRequestHandler;

public class FileChangeListener
implements FileAlterationListener {
    private static Logger log = LoggerFactory.getLogger(FileChangeListener.class);
    private DefaultHttpRequestHandler defaultHttpRequestHandler = null;

    FileChangeListener(DefaultHttpRequestHandler defaultHttpRequestHandler) {
        this.defaultHttpRequestHandler = defaultHttpRequestHandler;
    }

    public void removeCache(File file) {
        try {
            String path = this.defaultHttpRequestHandler.httpConfig.getPath(file);
            this.defaultHttpRequestHandler.staticResCache.remove(path);
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void onStart(FileAlterationObserver fileAlterationObserver) {
    }

    public void onDirectoryCreate(File file) {
    }

    public void onDirectoryChange(File file) {
    }

    public void onDirectoryDelete(File file) {
    }

    public void onFileCreate(File file) {
    }

    public void onFileChange(File file) {
        this.removeCache(file);
    }

    public void onFileDelete(File file) {
        this.removeCache(file);
    }

    public void onStop(FileAlterationObserver fileAlterationObserver) {
    }
}

