/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.java11.rest.config;

import java.net.http.HttpClient;
import net.dreamlu.mica.java11.rest.config.HttpClientRestProperties;
import net.dreamlu.mica.java11.rest.core.HttpClientHttpRequestFactory;
import net.dreamlu.mica.java11.rest.logger.RestTemplateLoggingInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HttpClientRestProperties.class})
public class RestTemplateConfiguration {
    @Bean
    public RestTemplate restTemplate(HttpClientRestProperties properties, ObjectProvider<RestTemplateBuilder> builderProvider) {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(properties.getConnectionTimeout()).followRedirects(properties.getRedirect()).version(properties.getVersion()).build();
        return ((RestTemplateBuilder)builderProvider.getIfAvailable(() -> new RestTemplateBuilder(new RestTemplateCustomizer[0]))).requestFactory(() -> new HttpClientHttpRequestFactory(httpClient, properties.getReadTimeout())).interceptors(new ClientHttpRequestInterceptor[]{new RestTemplateLoggingInterceptor(properties.getLevel())}).build();
    }
}

