/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.java11.feign.config.httpclient;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Http2Client
implements Client {
    private final HttpClient client;
    private static final Set<String> DISALLOWED_HEADERS_SET;

    public Http2Client() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_2).build());
    }

    public Http2Client(HttpClient client) {
        this.client = (HttpClient)Util.checkNotNull((Object)client, (String)"HttpClient must not be null", (Object[])new Object[0]);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpResponse<byte[]> httpResponse;
        HttpRequest httpRequest = this.newRequestBuilder(request, options).build();
        try {
            httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Invalid uri " + request.url(), e);
        }
        OptionalLong length = httpResponse.headers().firstValueAsLong("Content-Length");
        return Response.builder().body((InputStream)new ByteArrayInputStream(httpResponse.body()), length.isPresent() ? Integer.valueOf((int)length.getAsLong()) : null).reason(httpResponse.headers().firstValue("Reason-Phrase").orElse("OK")).request(request).status(httpResponse.statusCode()).headers(this.castMapCollectType(httpResponse.headers().map())).build();
    }

    private HttpRequest.Builder newRequestBuilder(Request request, Request.Options options) throws IOException {
        URI uri;
        try {
            uri = new URI(request.url());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid uri " + request.url(), e);
        }
        byte[] data = request.body();
        HttpRequest.BodyPublisher body = data == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray(data);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(options.readTimeoutMillis())).version(HttpClient.Version.HTTP_2);
        Map<String, Collection<String>> headers = this.filterRestrictedHeaders(request.headers());
        if (!headers.isEmpty()) {
            requestBuilder.headers(this.asString(headers));
        }
        switch (request.httpMethod()) {
            case GET: {
                return requestBuilder.GET();
            }
            case POST: {
                return requestBuilder.POST(body);
            }
            case PUT: {
                return requestBuilder.PUT(body);
            }
            case DELETE: {
                return requestBuilder.DELETE();
            }
        }
        return requestBuilder.method(request.httpMethod().toString(), body);
    }

    private Map<String, Collection<String>> filterRestrictedHeaders(Map<String, Collection<String>> headers) {
        Map<String, Collection<String>> filteredHeaders = headers.keySet().stream().filter(headerName -> !DISALLOWED_HEADERS_SET.contains(headerName)).collect(Collectors.toMap(Function.identity(), headers::get));
        filteredHeaders.computeIfAbsent("Accept", key -> List.of("*/*"));
        return filteredHeaders;
    }

    private Map<String, Collection<String>> castMapCollectType(Map<String, List<String>> map) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        map.forEach((key, value) -> result.put((String)key, new HashSet(value)));
        return result;
    }

    private String[] asString(Map<String, Collection<String>> headers) {
        return (String[])headers.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(value -> Arrays.asList((String)entry.getKey(), value)).flatMap(Collection::stream)).toArray(String[]::new);
    }

    static {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(Set.of("connection", "content-length", "date", "expect", "from", "host", "origin", "referer", "upgrade", "via", "warning"));
        DISALLOWED_HEADERS_SET = Collections.unmodifiableSet(treeSet);
    }
}

