/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.java11.feign.config;

import feign.Client;
import feign.Feign;
import java.net.http.HttpClient;
import net.dreamlu.mica.java11.feign.config.FeignHttpClientProperties;
import net.dreamlu.mica.java11.feign.config.httpclient.Http2Client;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.OnRetryNotEnabledCondition;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={Feign.class})
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={FeignJava11AutoConfiguration.class})
@EnableConfigurationProperties(value={FeignHttpClientProperties.class})
public class FeignJava11AutoConfiguration {
    @Bean
    public HttpClient httpClient(FeignHttpClientProperties properties) {
        return HttpClient.newBuilder().version(properties.getVersion()).followRedirects(properties.getRedirect()).connectTimeout(properties.getConnectionTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={OnRetryNotEnabledCondition.class})
    public Client feignClient(HttpClient httpClient, LoadBalancerClient loadBalancerClient, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        Http2Client delegate = new Http2Client(httpClient);
        return new FeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient, properties, loadBalancerClientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    @ConditionalOnBean(value={LoadBalancedRetryFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
    public Client feignRetryClient(LoadBalancerClient loadBalancerClient, HttpClient httpClient, LoadBalancedRetryFactory loadBalancedRetryFactory, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory) {
        Http2Client delegate = new Http2Client(httpClient);
        return new RetryableFeignBlockingLoadBalancerClient((Client)delegate, loadBalancerClient, loadBalancedRetryFactory, properties, loadBalancerClientFactory);
    }
}

