/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.java11.feign.config;

import feign.Client;
import feign.Feign;
import feign.http2client.Http2Client;
import java.net.http.HttpClient;
import net.dreamlu.mica.java11.feign.config.FeignHttpClientProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={Feign.class})
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={FeignJava11AutoConfiguration.class})
@EnableConfigurationProperties(value={FeignHttpClientProperties.class})
public class FeignJava11AutoConfiguration {
    @Bean
    public HttpClient httpClient(FeignHttpClientProperties properties) {
        return HttpClient.newBuilder().version(properties.getVersion()).followRedirects(properties.getRedirect()).connectTimeout(properties.getConnectionTimeout()).build();
    }

    @Bean
    public Client feignClient(HttpClient client, CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory) {
        Http2Client http2Client = new Http2Client(client);
        return new LoadBalancerFeignClient((Client)http2Client, cachingFactory, clientFactory);
    }
}

