/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.spring;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.wxaapp.WxaConfigKit;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.weixin.annotation.WxApi;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import net.dreamlu.weixin.spring.MsgController;
import net.dreamlu.weixin.spring.WebUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MsgInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(MsgInterceptor.class);
    private final DreamWeixinProperties weixinProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class beanType = handlerMethod.getBeanType();
        WxApi wxApi = (WxApi)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, WxApi.class);
        String appId = request.getParameter(this.weixinProperties.getAppIdKey());
        if (wxApi != null) {
            ApiConfigKit.setThreadLocalAppId((String)appId);
            return true;
        }
        Object bean = handlerMethod.getBean();
        boolean isWx = bean instanceof MsgController;
        String token = isWx ? ApiConfigKit.getApiConfig((String)appId).getToken() : WxaConfigKit.getWxaConfig().getToken();
        if (this.isConfigServerRequest(request)) {
            this.configServer(request, response, token);
            return false;
        }
        if (isWx) {
            ApiConfigKit.setThreadLocalAppId((String)appId);
        }
        if (ApiConfigKit.isDevMode()) {
            return true;
        }
        if (this.checkSignature(request, token)) {
            return true;
        }
        WebUtils.renderText(response, "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u662f\u5fae\u4fe1\u670d\u52a1\u5668\u5728\u53d1\u9001\u6d88\u606f\u8fc7\u6765");
        return false;
    }

    private boolean checkSignature(HttpServletRequest request, String token) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        if (StrKit.isBlank((String)signature) || StrKit.isBlank((String)timestamp) || StrKit.isBlank((String)nonce)) {
            logger.error((Object)"check signature failure");
            return false;
        }
        if (this.checkSignature(token, signature, timestamp, nonce)) {
            return true;
        }
        logger.error((Object)("check signature failure:  signature = " + signature + " timestamp = " + timestamp + " nonce = " + nonce));
        return false;
    }

    private boolean isConfigServerRequest(HttpServletRequest request) {
        return StrKit.notBlank((String)request.getParameter("echostr"));
    }

    private void configServer(HttpServletRequest request, HttpServletResponse response, String token) {
        String nonce;
        String timestamp;
        String echostr = request.getParameter("echostr");
        String signature = request.getParameter("signature");
        boolean isOk = this.checkSignature(token, signature, timestamp = request.getParameter("timestamp"), nonce = request.getParameter("nonce"));
        if (isOk && !response.isCommitted()) {
            WebUtils.renderText(response, echostr);
        } else {
            logger.error((Object)"\u9a8c\u8bc1\u5931\u8d25\uff1aconfigServer");
        }
    }

    private boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        Object[] array = new String[]{token, timestamp, nonce};
        Arrays.sort(array);
        String tempStr = (String)array[0] + (String)array[1] + (String)array[2];
        tempStr = HashKit.sha1((String)tempStr);
        return tempStr.equalsIgnoreCase(signature);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
        ApiConfigKit.removeThreadLocalAppId();
    }

    public MsgInterceptor(DreamWeixinProperties weixinProperties) {
        this.weixinProperties = weixinProperties;
    }
}

