/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.config;

import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JacksonFactory;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import java.util.List;
import net.dreamlu.weixin.cache.SpringAccessTokenCache;
import net.dreamlu.weixin.config.WxaMsgParser;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WeixinAppConfig
implements SmartInitializingSingleton {
    private final DreamWeixinProperties weixinProperties;
    private final SpringAccessTokenCache accessTokenCache;

    public void afterSingletonsInstantiated() {
        boolean isdev = this.weixinProperties.isDevMode();
        ApiConfigKit.setDevMode((boolean)isdev);
        ApiConfigKit.setAccessTokenCache((IAccessTokenCache)this.accessTokenCache);
        List<DreamWeixinProperties.ApiConfig> list = this.weixinProperties.getWxConfigs();
        for (DreamWeixinProperties.ApiConfig apiConfig : list) {
            ApiConfig config = new ApiConfig();
            if (StrKit.notBlank((String)apiConfig.getAppId())) {
                config.setAppId(apiConfig.getAppId());
            }
            if (StrKit.notBlank((String)apiConfig.getAppSecret())) {
                config.setAppSecret(apiConfig.getAppSecret());
            }
            if (StrKit.notBlank((String)apiConfig.getToken())) {
                config.setToken(apiConfig.getToken());
            }
            if (StrKit.notBlank((String)apiConfig.getEncodingAesKey())) {
                config.setEncodingAesKey(apiConfig.getEncodingAesKey());
            }
            config.setEncryptMessage(apiConfig.isMessageEncrypt());
            ApiConfigKit.putApiConfig((ApiConfig)config);
        }
        DreamWeixinProperties.WxaConfig apiConfig = this.weixinProperties.getWxaConfig();
        WxaConfig config = new WxaConfig();
        if (StrKit.notBlank((String)apiConfig.getAppId())) {
            config.setAppId(apiConfig.getAppId());
        }
        if (StrKit.notBlank((String)apiConfig.getAppSecret())) {
            config.setAppSecret(apiConfig.getAppSecret());
        }
        if (StrKit.notBlank((String)apiConfig.getToken())) {
            config.setToken(apiConfig.getToken());
        }
        if (StrKit.notBlank((String)apiConfig.getEncodingAesKey())) {
            config.setEncodingAesKey(apiConfig.getEncodingAesKey());
        }
        config.setMessageEncrypt(apiConfig.isMessageEncrypt());
        WxaConfigKit.setDevMode((boolean)isdev);
        WxaConfigKit.setWxaConfig((WxaConfig)config);
        if (WxaMsgParser.JSON == this.weixinProperties.getWxaMsgParser()) {
            WxaConfigKit.useJsonMsgParser();
        }
        if ("jackson".equals(this.weixinProperties.getJsonType())) {
            JsonUtils.setJsonFactory((IJsonFactory)JacksonFactory.me());
        }
    }

    public WeixinAppConfig(DreamWeixinProperties weixinProperties, SpringAccessTokenCache accessTokenCache) {
        this.weixinProperties = weixinProperties;
        this.accessTokenCache = accessTokenCache;
    }
}

