/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.spring;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.kit.SignatureCheckKit;
import java.lang.reflect.AnnotatedElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.weixin.annotation.WxApi;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import net.dreamlu.weixin.spring.DreamWxaMsgController;
import net.dreamlu.weixin.spring.WebUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MsgInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(MsgInterceptor.class);
    private final DreamWeixinProperties weixinProperties;

    public MsgInterceptor(DreamWeixinProperties weixinProperties) {
        this.weixinProperties = weixinProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class beanType = handlerMethod.getBeanType();
        WxApi wxApi = (WxApi)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, WxApi.class);
        String appId = request.getParameter(this.weixinProperties.getAppIdKey());
        if (wxApi != null) {
            ApiConfigKit.setThreadLocalAppId((String)appId);
            return true;
        }
        Object bean = handlerMethod.getBean();
        if (bean instanceof DreamWxaMsgController) {
            return true;
        }
        ApiConfigKit.setThreadLocalAppId((String)appId);
        if (this.isConfigServerRequest(request)) {
            this.configServer(request, response);
            return false;
        }
        if (ApiConfigKit.isDevMode()) {
            return true;
        }
        if (this.checkSignature(request, response)) {
            return true;
        }
        WebUtils.renderText(response, "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u662f\u5fae\u4fe1\u670d\u52a1\u5668\u5728\u53d1\u9001\u6d88\u606f\u8fc7\u6765");
        return false;
    }

    private boolean checkSignature(HttpServletRequest request, HttpServletResponse response) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        if (StrKit.isBlank((String)signature) || StrKit.isBlank((String)timestamp) || StrKit.isBlank((String)nonce)) {
            logger.error((Object)"check signature failure");
            return false;
        }
        if (SignatureCheckKit.me.checkSignature(signature, timestamp, nonce)) {
            return true;
        }
        logger.error((Object)("check signature failure:  signature = " + signature + " timestamp = " + timestamp + " nonce = " + nonce));
        return false;
    }

    private boolean isConfigServerRequest(HttpServletRequest request) {
        return StrKit.notBlank((String)request.getParameter("echostr"));
    }

    private void configServer(HttpServletRequest request, HttpServletResponse response) {
        String nonce;
        String timestamp;
        String echostr = request.getParameter("echostr");
        String signature = request.getParameter("signature");
        boolean isOk = SignatureCheckKit.me.checkSignature(signature, timestamp = request.getParameter("timestamp"), nonce = request.getParameter("nonce"));
        if (isOk && !response.isCommitted()) {
            WebUtils.renderText(response, echostr);
        } else {
            logger.error((Object)"\u9a8c\u8bc1\u5931\u8d25\uff1aconfigServer");
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
        ApiConfigKit.removeThreadLocalAppId();
    }
}

