/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.config;

import net.dreamlu.weixin.cache.SpringAccessTokenCache;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import net.dreamlu.weixin.spring.MsgInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={DreamWeixinProperties.class})
public class DreamWeixinAutoConfiguration {
    private final CacheManager cacheManager;

    @Bean
    public SpringAccessTokenCache springAccessTokenCache(DreamWeixinProperties properties) {
        Cache cache = this.cacheManager.getCache(properties.getAccessTokenCache());
        return new SpringAccessTokenCache(cache);
    }

    public DreamWeixinAutoConfiguration(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Configuration
    public static class MsgConfiguration
    extends WebMvcConfigurerAdapter {
        private final DreamWeixinProperties properties;

        public MsgConfiguration(DreamWeixinProperties properties) {
            this.properties = properties;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            String urlPattern = this.properties.getUrlPatterns();
            MsgInterceptor httpCacheInterceptor = new MsgInterceptor(this.properties);
            registry.addInterceptor((HandlerInterceptor)httpCacheInterceptor).addPathPatterns(new String[]{urlPattern});
        }
    }
}

