/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.config;

import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import java.util.List;
import net.dreamlu.weixin.config.WxaMsgParser;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import org.springframework.beans.factory.InitializingBean;

public class WeixinAppConfig
implements InitializingBean {
    private final DreamWeixinProperties weixinProperties;

    public WeixinAppConfig(DreamWeixinProperties weixinProperties) {
        this.weixinProperties = weixinProperties;
    }

    public void afterPropertiesSet() throws Exception {
        boolean isdev = this.weixinProperties.isDevMode();
        ApiConfigKit.setDevMode((boolean)isdev);
        List<ApiConfig> list = this.weixinProperties.getWxConfigs();
        for (ApiConfig apiConfig : list) {
            ApiConfigKit.putApiConfig((ApiConfig)apiConfig);
        }
        WxaConfig wxaConfig = this.weixinProperties.getWxaConfig();
        WxaConfigKit.setDevMode((boolean)isdev);
        WxaConfigKit.setWxaConfig((WxaConfig)wxaConfig);
        if (WxaMsgParser.JSON == this.weixinProperties.getWxaMsgParser()) {
            WxaConfigKit.useJsonMsgParser();
        }
    }
}

