/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.config;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;
import com.jfinal.core.JFinal;
import com.jfinal.json.IJsonFactory;
import com.jfinal.json.JacksonFactory;
import com.jfinal.template.Engine;
import java.util.Map;
import javax.servlet.ServletContext;
import net.dreamlu.weixin.annotation.WxMsgController;
import net.dreamlu.weixin.config.SpringControllerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DreamWeixinConfig
extends JFinalConfig {
    public void configConstant(Constants me) {
        me.setJsonFactory((IJsonFactory)new JacksonFactory());
        me.setControllerFactory((ControllerFactory)new SpringControllerFactory());
    }

    public void configRoute(Routes me) {
        DreamWeixinConfig.findAnnotatedBeans(me);
    }

    public void configEngine(Engine me) {
    }

    public void configPlugin(Plugins me) {
    }

    public void configInterceptor(Interceptors me) {
    }

    public void configHandler(Handlers me) {
    }

    public static void findAnnotatedBeans(Routes me) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)JFinal.me().getServletContext());
        Map controllerMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, Controller.class);
        for (Controller controller : controllerMap.values()) {
            Class<?> controllerClass = controller.getClass();
            WxMsgController wxController = (WxMsgController)AnnotationUtils.findAnnotation(controllerClass, WxMsgController.class);
            if (wxController == null) continue;
            me.add(wxController.value(), controllerClass);
        }
    }
}

