/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.config;

import com.jfinal.core.JFinalFilter;
import javax.servlet.Filter;
import net.dreamlu.weixin.aspect.WxApiAspect;
import net.dreamlu.weixin.cache.SpringAccessTokenCache;
import net.dreamlu.weixin.config.DreamWeixinConfig;
import net.dreamlu.weixin.config.WeixinAppConfig;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DreamWeixinProperties.class})
public class DreamWeixinAutoConfiguration {
    private final CacheManager cacheManager;
    private final DreamWeixinProperties weixinProperties;

    public DreamWeixinAutoConfiguration(CacheManager cacheManager, DreamWeixinProperties weixinProperties) {
        this.cacheManager = cacheManager;
        this.weixinProperties = weixinProperties;
    }

    @Bean
    public FilterRegistrationBean jfinalFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        JFinalFilter jfinalFilter = new JFinalFilter();
        registration.setFilter((Filter)jfinalFilter);
        registration.addUrlPatterns(new String[]{this.weixinProperties.getUrlPatterns()});
        registration.addInitParameter("configClass", DreamWeixinConfig.class.getName());
        registration.setName("jfinalFilter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public WeixinAppConfig weixinAppConfig() {
        return new WeixinAppConfig(this.weixinProperties);
    }

    @Bean
    public SpringAccessTokenCache springAccessTokenCache() {
        Cache cache = this.cacheManager.getCache(this.weixinProperties.getAccessTokenCache());
        return new SpringAccessTokenCache(cache);
    }

    @Bean
    public WxApiAspect wxApiAspect() {
        return new WxApiAspect(this.weixinProperties);
    }
}

