/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.weixin.aspect;

import com.jfinal.weixin.sdk.api.ApiConfigKit;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.weixin.annotation.WxApi;
import net.dreamlu.weixin.properties.DreamWeixinProperties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order
public class WxApiAspect {
    private static final Logger log = LoggerFactory.getLogger(WxApiAspect.class);
    private final DreamWeixinProperties weixinProperties;

    public WxApiAspect(DreamWeixinProperties weixinProperties) {
        this.weixinProperties = weixinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(wxApi)")
    public Object aroundWxApi(ProceedingJoinPoint point, WxApi wxApi) throws Throwable {
        HttpServletRequest request = this.getRequest();
        try {
            String appId = request.getParameter(this.weixinProperties.getAppIdKey());
            ApiConfigKit.setThreadLocalAppId((String)appId);
            Object object = point.proceed();
            return object;
        }
        finally {
            ApiConfigKit.removeThreadLocalAppId();
        }
    }

    private HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }
}

