/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common.sse;

import java.nio.charset.StandardCharsets;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.EncodedPacket;
import org.tio.core.intf.Packet;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.sse.SseEvent;
import org.tio.utils.SysConst;

public class SseEmitter {
    private final HttpRequest request;

    SseEmitter(HttpRequest request) {
        this.request = request;
    }

    public void send(Object data) {
        this.send(new SseEvent().data(data));
    }

    public void send(String event, Object data) {
        this.send(new SseEvent().name(event).data(data));
    }

    public void send(String id, String event, Object data) {
        this.send(new SseEvent().id(id).name(event).data(data));
    }

    public void send(long id, String event, Object data) {
        this.send(new SseEvent().id(id).name(event).data(data));
    }

    public void send(SseEvent sseEvent) {
        String chunkedString = sseEvent.toString();
        byte[] chunkedBytes = chunkedString.getBytes(this.request.getCharset());
        EncodedPacket encodedPacket = new EncodedPacket(SseEmitter.encodeChunk(chunkedBytes));
        Tio.send((ChannelContext)this.request.channelContext, (Packet)encodedPacket);
    }

    public void close() {
        this.request.close("\u4e3b\u52a8\u5173\u95ed sse \u8fde\u63a5");
    }

    public static SseEmitter getEmitter(HttpRequest request, HttpResponse response) {
        response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_EVENT_STREAM);
        response.addHeader(HeaderName.Connection, HeaderValue.Connection.keep_alive);
        response.addHeader(HeaderName.Transfer_Encoding, HeaderValue.Transfer_Encoding.chunked);
        return new SseEmitter(request);
    }

    private static byte[] encodeChunk(byte[] chunkData) {
        int length = chunkData.length;
        String chunkSize = Integer.toHexString(length);
        byte[] chunkSizeBytes = (chunkSize + "\r\n").getBytes(StandardCharsets.US_ASCII);
        byte[] chunk = new byte[chunkSizeBytes.length + length + 2];
        System.arraycopy(chunkSizeBytes, 0, chunk, 0, chunkSizeBytes.length);
        System.arraycopy(chunkData, 0, chunk, chunkSizeBytes.length, length);
        System.arraycopy(SysConst.CR_LF, 0, chunk, chunkSizeBytes.length + length, 2);
        return chunk;
    }
}

