/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.nio.charset.Charset;
import java.util.Arrays;

public class HeaderValue {
    public final String value;
    public final byte[] bytes;

    private HeaderValue(String name) {
        this.value = name;
        this.bytes = name.getBytes();
    }

    private HeaderValue(String name, Charset charset) {
        this.value = name;
        this.bytes = name.getBytes(charset);
    }

    public static HeaderValue from(String name) {
        return new HeaderValue(name);
    }

    public static HeaderValue from(String name, Charset charset) {
        return new HeaderValue(name, charset);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderValue that = (HeaderValue)o;
        return this.value.equals(that.value) && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public static class Content_Type {
        public static final HeaderValue TEXT_PLAIN = HeaderValue.from("text/plain");
        public static final HeaderValue TEXT_HTML = HeaderValue.from("text/html");
        public static final HeaderValue TEXT_EVENT_STREAM = HeaderValue.from("text/event-stream");
        public static final HeaderValue APPLICATION_JSON = HeaderValue.from("application/json");
        public static final HeaderValue DEFAULT_TYPE = HeaderValue.from("application/octet-stream");
    }

    public static class Transfer_Encoding {
        public static final HeaderValue chunked = HeaderValue.from("chunked");
    }

    public static class Content_Encoding {
        public static final HeaderValue gzip = HeaderValue.from("gzip");
    }

    public static class Server {
        public static final HeaderValue SERVER_INFO = HeaderValue.from("mica-net");
    }

    public static class Cache_Control {
        public static final HeaderValue no_cache = HeaderValue.from("no-cache");
        public static final HeaderValue MAX_AGE_60 = HeaderValue.from("max-age:60");
    }

    public static class Keep_Alive {
        public static final HeaderValue TIMEOUT_10_MAX_20 = HeaderValue.from("timeout=10, max=20");
    }

    public static class Upgrade {
        public static final HeaderValue WebSocket = HeaderValue.from("WebSocket");
    }

    public static class Connection {
        public static final HeaderValue keep_alive = HeaderValue.from("keep-alive");
        public static final HeaderValue close = HeaderValue.from("close");
        public static final HeaderValue Upgrade = HeaderValue.from("Upgrade");
    }
}

