/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.http.common.Cookie;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.utils.HttpGzipUtils;
import org.tio.utils.SysConst;
import org.tio.utils.hutool.DateUtil;

public class HttpResponseEncoder {
    public static final int HEADER_SERVER_LENGTH = HeaderName.Server.bytes.length + HeaderValue.Server.SERVER_INFO.bytes.length + 4;
    public static final int HEADER_DATE_LENGTH_1 = HeaderName.Date.bytes.length + 4;
    public static final int HEADER_FIXED_LENGTH = HEADER_SERVER_LENGTH + HEADER_DATE_LENGTH_1;
    private static final Logger log = LoggerFactory.getLogger(HttpResponseEncoder.class);

    private HttpResponseEncoder() {
    }

    public static ByteBuffer encode(HttpResponse httpResponse, TioConfig tioConfig, ChannelContext channelContext) {
        int bodyLength = 0;
        byte[] body = httpResponse.body;
        if (body != null) {
            HttpRequest httpRequest = httpResponse.getHttpRequest();
            try {
                HttpGzipUtils.gzip(httpRequest, httpResponse);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            body = httpResponse.body;
            bodyLength = body.length;
        }
        HttpResponseStatus httpResponseStatus = httpResponse.getStatus();
        int respLineLength = httpResponseStatus.responseLineBinary.length;
        Map<HeaderName, HeaderValue> headers = httpResponse.getHeaders();
        httpResponse.addHeader(HeaderName.Content_Length, HeaderValue.from(Integer.toString(bodyLength)));
        int headerLength = httpResponse.getHeaderByteCount();
        if (httpResponse.getCookies() != null) {
            for (Cookie cookie : httpResponse.getCookies()) {
                headerLength += HeaderName.SET_COOKIE.bytes.length;
                byte[] bs = cookie.toString().getBytes(httpResponse.getCharset());
                cookie.setBytes(bs);
                headerLength += bs.length;
            }
            headerLength += httpResponse.getCookies().size() * 4;
        }
        HeaderValue httpDateValue = HeaderValue.from(DateUtil.httpDate());
        ByteBuffer buffer = ByteBuffer.allocate(respLineLength + (headerLength += HEADER_FIXED_LENGTH + httpDateValue.bytes.length) + bodyLength);
        buffer.put(httpResponseStatus.responseLineBinary);
        buffer.put(HeaderName.Server.bytes);
        buffer.put((byte)58);
        buffer.put((byte)32);
        buffer.put(HeaderValue.Server.SERVER_INFO.bytes);
        buffer.put(SysConst.CR_LF);
        buffer.put(HeaderName.Date.bytes);
        buffer.put((byte)58);
        buffer.put((byte)32);
        buffer.put(httpDateValue.bytes);
        buffer.put(SysConst.CR_LF);
        Set<Map.Entry<HeaderName, HeaderValue>> headerSet = headers.entrySet();
        for (Map.Entry<HeaderName, HeaderValue> entry : headerSet) {
            buffer.put(entry.getKey().bytes);
            buffer.put((byte)58);
            buffer.put((byte)32);
            buffer.put(entry.getValue().bytes);
            buffer.put(SysConst.CR_LF);
        }
        if (httpResponse.getCookies() != null) {
            for (Cookie cookie : httpResponse.getCookies()) {
                buffer.put(HeaderName.SET_COOKIE.bytes);
                buffer.put((byte)58);
                buffer.put((byte)32);
                buffer.put(cookie.getBytes());
                buffer.put(SysConst.CR_LF);
            }
        }
        buffer.put(SysConst.CR_LF);
        if (bodyLength > 0) {
            buffer.put(body);
        }
        buffer.flip();
        return buffer;
    }
}

