/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.server.intf.TioServerHandler;

public class HttpTioServerHandler
implements TioServerHandler {
    public static final String REQUEST_KEY = "tio_req_key";
    private static final Logger log = LoggerFactory.getLogger(HttpTioServerHandler.class);
    protected final HttpConfig httpConfig;
    private final HttpRequestHandler requestHandler;

    public HttpTioServerHandler(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this.httpConfig = httpConfig;
        this.requestHandler = requestHandler;
    }

    public HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        HttpRequest request = HttpRequestDecoder.decode(buffer, limit, position, readableLength, channelContext, this.httpConfig);
        if (request != null) {
            channelContext.set(REQUEST_KEY, (Object)request);
        }
        return request;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        return HttpResponseEncoder.encode((HttpResponse)packet);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void handler(Packet packet, ChannelContext context) throws Exception {
        HttpRequest request = (HttpRequest)packet;
        HttpResponse httpResponse = this.requestHandler.handler(request);
        if (httpResponse != null) {
            Tio.send((ChannelContext)context, (Packet)httpResponse);
        } else {
            if (log.isInfoEnabled()) {
                log.info("{}, {}, handler return null, request line: {}", new Object[]{context.tioConfig.getName(), context, request.getRequestLine()});
            }
            request.close("handler return null");
        }
    }
}

