/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.mcp.server;

import org.tio.http.jsonrpc.JsonRpcMessage;
import org.tio.http.sse.SseEmitter;
import org.tio.http.sse.SseEvent;
import org.tio.utils.json.JsonUtil;

public class McpServerSession {
    public static final String MESSAGE_EVENT_TYPE = "message";
    private final String sessionId;
    private final SseEmitter sseEmitter;

    public McpServerSession(String sessionId, SseEmitter sseEmitter) {
        this.sessionId = sessionId;
        this.sseEmitter = sseEmitter;
    }

    public void sendHeartbeat() {
        this.sseEmitter.send(new SseEvent().comment("heartbeat"));
    }

    public void sendMessage(JsonRpcMessage message) {
        this.sseEmitter.send(MESSAGE_EVENT_TYPE, JsonUtil.toJsonString((Object)message));
    }

    public void close() {
        this.sseEmitter.close();
    }

    public String toString() {
        return "McpServerSession{sessionId='" + this.sessionId + '\'' + '}';
    }
}

