/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.tio.core.intf.TioUuid;
import org.tio.core.uuid.SnowflakeTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.server.IServer;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.server.WsTioServerHandler;
import org.tio.websocket.server.WsTioServerListener;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerStarter
implements IServer {
    private final HttpConfig wsServerConfig;
    private final IWsMsgHandler wsMsgHandler;
    private final WsTioServerHandler wsTioServerHandler;
    private final WsTioServerListener wsTioServerListener;
    private final TioServerConfig tioServerConfig;
    private final TioServer tioServer;

    public WsServerStarter(IWsMsgHandler wsMsgHandler) {
        this(wsMsgHandler, null, null);
    }

    public WsServerStarter(IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this(new HttpConfig(), wsMsgHandler, tioExecutor, groupExecutor);
    }

    public WsServerStarter(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler) {
        this(wsServerConfig, wsMsgHandler, null, null);
    }

    public WsServerStarter(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = Objects.requireNonNull(wsMsgHandler);
        this.wsTioServerHandler = new WsTioServerHandler(wsServerConfig, wsMsgHandler);
        this.wsTioServerListener = new WsTioServerListener();
        this.tioServerConfig = new TioServerConfig("Tio Websocket Server", (TioServerHandler)this.wsTioServerHandler, (TioServerListener)this.wsTioServerListener, tioExecutor, (ExecutorService)groupExecutor);
        this.tioServerConfig.setHeartbeatTimeout(0L);
        this.tioServerConfig.setTioUuid((TioUuid)new SnowflakeTioUuid());
        this.tioServerConfig.setReadBufferSize(30720);
        this.tioServer = new TioServer(this.tioServerConfig);
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    public HttpConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public IWsMsgHandler getWsMsgHandler() {
        return this.wsMsgHandler;
    }

    public WsTioServerHandler getWsTioServerHandler() {
        return this.wsTioServerHandler;
    }

    public WsTioServerListener getWsTioServerListener() {
        return this.wsTioServerListener;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        this.tioServer.start(serverIp, serverPort);
    }

    public boolean stop() {
        return this.tioServer.stop();
    }
}

