/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;

public class HeaderValue {
    public final String value;
    public final byte[] bytes;

    private HeaderValue(String name) {
        this.value = name;
        this.bytes = name.getBytes();
    }

    private HeaderValue(String name, String charset) throws UnsupportedEncodingException {
        this.value = name;
        this.bytes = name.getBytes(charset);
    }

    public static HeaderValue from(String name) {
        return new HeaderValue(name);
    }

    public static HeaderValue from(String name, String charset) throws UnsupportedEncodingException {
        return new HeaderValue(name, charset);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderValue other = (HeaderValue)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public static class Content_Encoding
    extends EnumerableValue {
        public static final HeaderValue gzip = HeaderValue.from("gzip");
    }

    public static class Server {
        public static final HeaderValue SERVER_INFO = HeaderValue.from("mica-net");
    }

    public static class Cache_Control {
        public static final HeaderValue MAX_AGE_60 = HeaderValue.from("max-age:60");
    }

    public static class Keep_Alive
    extends EnumerableValue {
        public static final HeaderValue TIMEOUT_10_MAX_20 = HeaderValue.from("timeout=10, max=20");
    }

    public static class Upgrade
    extends EnumerableValue {
        public static final HeaderValue WebSocket = HeaderValue.from("WebSocket");
    }

    public static class Connection
    extends EnumerableValue {
        public static final HeaderValue keep_alive = HeaderValue.from("keep-alive");
        public static final HeaderValue close = HeaderValue.from("close");
        public static final HeaderValue Upgrade = HeaderValue.from("Upgrade");
    }

    public static class EnumerableValue {
        private static final ConcurrentMap<String, HeaderValue> map = new ConcurrentHashMap<String, HeaderValue>();

        public static HeaderValue from(String value) {
            if (StrUtil.isBlank((CharSequence)value)) {
                return null;
            }
            return (HeaderValue)CollUtil.computeIfAbsent(map, (Object)value, HeaderValue::from);
        }
    }
}

