/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.tio.http.common.Method;
import org.tio.utils.hutool.StrUtil;

public class RequestLine {
    public Method method;
    public String path;
    public String initPath;
    public String queryString;
    public String protocol;
    public String version;

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPathAndQuery() {
        if (StrUtil.isNotBlank((CharSequence)this.queryString)) {
            return this.path + '?' + this.queryString;
        }
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getInitPath() {
        return this.initPath;
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.value).append(' ').append(this.path);
        if (StrUtil.isNotBlank((CharSequence)this.queryString)) {
            sb.append('?').append(this.queryString);
        }
        sb.append(' ');
        sb.append(this.protocol).append('/').append(this.version);
        return sb.toString();
    }

    public String toUrlEncodedString(String charset) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.value).append(' ').append(this.path);
        if (StrUtil.isNotBlank((CharSequence)this.queryString)) {
            sb.append('?');
            String[] keyValues = this.queryString.split("&");
            int i = 0;
            for (String keyValue : keyValues) {
                String[] keyValueArray = keyValue.split("=");
                if (keyValueArray.length == 2) {
                    String name = keyValueArray[0];
                    String value = keyValueArray[1];
                    if (StrUtil.isNotBlank((CharSequence)charset)) {
                        try {
                            sb.append(name).append('=').append(URLEncoder.encode(value, charset));
                        }
                        catch (UnsupportedEncodingException e) {
                            sb.append(name).append('=').append(URLEncoder.encode(value));
                        }
                    } else {
                        sb.append(name).append('=').append(URLEncoder.encode(value));
                    }
                    if (i != keyValues.length - 1) {
                        sb.append('&');
                    }
                }
                ++i;
            }
        }
        sb.append(' ');
        sb.append(this.protocol).append('/').append(this.version);
        return sb.toString();
    }
}

