/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tio.http.common.Cookie;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpPacket;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.utils.HttpGzipUtils;
import org.tio.utils.hutool.StrUtil;

public class HttpResponse
extends HttpPacket {
    public static final HttpResponse NULL_RESPONSE = new HttpResponse();
    private static final long serialVersionUID = -3512681144230291786L;
    private final Map<HeaderName, HeaderValue> headers = new HashMap<HeaderName, HeaderValue>();
    private HttpResponseStatus status = HttpResponseStatus.C200;
    private boolean isStaticRes = false;
    private HttpRequest request = null;
    private List<Cookie> cookies = null;
    private int headerByteCount = 2;
    private boolean hasGzipped = false;
    private Charset charset = HttpConst.CHARSET;
    private boolean skipIpStat = false;
    private boolean skipTokenStat = false;

    public HttpResponse() {
    }

    public HttpResponse(HttpRequest request) {
        this();
        this.request = request;
        if (request == null) {
            return;
        }
        if (request.httpConfig != null && request.httpConfig.compatible1_0) {
            String connection = request.getConnection();
            if ("1.0".equals(request.requestLine.version)) {
                if (StrUtil.equals((CharSequence)connection, (CharSequence)"keep-alive")) {
                    this.addHeader(HeaderName.Connection, HeaderValue.Connection.keep_alive);
                    this.addHeader(HeaderName.Keep_Alive, HeaderValue.Keep_Alive.TIMEOUT_10_MAX_20);
                }
            } else if (StrUtil.equals((CharSequence)connection, (CharSequence)"close")) {
                // empty if block
            }
        }
    }

    public HttpResponse(Map<HeaderName, HeaderValue> responseHeaders, byte[] body) {
        if (responseHeaders != null) {
            this.headers.putAll(responseHeaders);
        }
        this.setBody(body);
        HttpGzipUtils.gzip(this);
    }

    public static HttpResponse cloneResponse(HttpRequest request, HttpResponse response) {
        HttpResponse cloneResponse = new HttpResponse(request);
        cloneResponse.setStatus(response.getStatus());
        cloneResponse.setBody(response.getBody());
        cloneResponse.setHasGzipped(response.isHasGzipped());
        cloneResponse.addHeaders(response.getHeaders());
        if (cloneResponse.getCookies() != null) {
            cloneResponse.getCookies().clear();
        }
        return cloneResponse;
    }

    public Map<HeaderName, HeaderValue> getHeaders() {
        return this.headers;
    }

    public void addHeader(HeaderName key, HeaderValue value) {
        this.headers.put(key, value);
        this.headerByteCount += key.bytes.length + value.bytes.length + 3;
    }

    public void addHeaders(Map<HeaderName, HeaderValue> headers) {
        if (headers != null) {
            Set<Map.Entry<HeaderName, HeaderValue>> set = headers.entrySet();
            for (Map.Entry<HeaderName, HeaderValue> entry : set) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public HeaderValue getContentType() {
        return this.headers.get(HeaderName.Content_Type);
    }

    public boolean addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        return this.cookies.add(cookie);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public boolean isStaticRes() {
        return this.isStaticRes;
    }

    public void setStaticRes(boolean isStaticRes) {
        this.isStaticRes = isStaticRes;
    }

    public String logstr() {
        String str;
        if (this.request != null) {
            str = "\r\n\u54cd\u5e94: \u8bf7\u6c42ID_" + this.request.getId() + ' ' + this.request.getRequestLine().getPathAndQuery();
            str = str + "\r\n" + this.getHeaderString();
        } else {
            str = "\r\n\u54cd\u5e94\r\n" + this.status.getHeaderText();
        }
        return str;
    }

    public void setHttpRequestPacket(HttpRequest request) {
        this.request = request;
    }

    public boolean isHasGzipped() {
        return this.hasGzipped;
    }

    public void setHasGzipped(boolean hasGzipped) {
        this.hasGzipped = hasGzipped;
    }

    public boolean isSkipIpStat() {
        return this.skipIpStat;
    }

    public void setSkipIpStat(boolean skipIpStat) {
        this.skipIpStat = skipIpStat;
    }

    public boolean isSkipTokenStat() {
        return this.skipTokenStat;
    }

    public void setSkipTokenStat(boolean skipTokenStat) {
        this.skipTokenStat = skipTokenStat;
    }

    public HeaderValue getLastModified() {
        return this.getHeader(HeaderName.Last_Modified);
    }

    public void setLastModified(HeaderValue lastModified) {
        if (lastModified != null) {
            this.addHeader(HeaderName.Last_Modified, lastModified);
        }
    }

    public HeaderValue getHeader(HeaderName name) {
        return this.headers.get(name);
    }

    public String toString() {
        return this.status.toString();
    }

    public int getHeaderByteCount() {
        return this.headerByteCount;
    }
}

