/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

public enum Opcode {
    NOT_FIN(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    private final byte code;

    private Opcode(byte code) {
        this.code = code;
    }

    public static Opcode valueOf(byte code) {
        switch (code) {
            case 0: {
                return NOT_FIN;
            }
            case 1: {
                return TEXT;
            }
            case 2: {
                return BINARY;
            }
            case 8: {
                return CLOSE;
            }
            case 9: {
                return PING;
            }
            case 10: {
                return PONG;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + code);
    }

    public byte getCode() {
        return this.code;
    }
}

