/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.utils.hutool.StrUtil;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String[] HEADER_NAMES_FOR_REALIP = new String[]{"x-forwarded-for", "proxy-client-ip", "wl-proxy-client-ip", "x-real-ip"};
    private static final Pattern IP_PATTERN = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");

    public static String getLocalIp() throws SocketException {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress ip = null;
        boolean finded = false;
        block0: while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                ip = address.nextElement();
                if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                    netip = ip.getHostAddress();
                    finded = true;
                    continue block0;
                }
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                localip = ip.getHostAddress();
            }
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    public static String getRealIp(HttpRequest request) {
        if (request.httpConfig == null) {
            return request.getRemote().getIp();
        }
        if (request.httpConfig.isProxied()) {
            String name;
            String headerName = null;
            String ip = null;
            String[] stringArray = HEADER_NAMES_FOR_REALIP;
            int n = stringArray.length;
            for (int i = 0; i < n && (!StrUtil.isNotBlank((CharSequence)(ip = request.getHeader(headerName = (name = stringArray[i])))) || "unknown".equalsIgnoreCase(ip)); ++i) {
            }
            if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
                headerName = null;
                ip = request.getRemote().getIp();
            }
            if (ip.contains(",")) {
                log.error("ip[{}], header name:{}", (Object)ip, (Object)headerName);
                ip = ip.split(",")[0].trim();
            }
            return ip;
        }
        return request.getRemote().getIp();
    }

    public static String getRealIp(ChannelContext channelContext, HttpConfig httpConfig, Map<String, String> httpHeaders) {
        if (httpConfig == null) {
            return channelContext.getClientNode().getIp();
        }
        if (httpConfig.isProxied()) {
            String name;
            String headerName = null;
            String ip = null;
            String[] stringArray = HEADER_NAMES_FOR_REALIP;
            int n = stringArray.length;
            for (int i = 0; i < n && (!StrUtil.isNotBlank((CharSequence)(ip = httpHeaders.get(headerName = (name = stringArray[i])))) || "unknown".equalsIgnoreCase(ip)); ++i) {
            }
            if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
                headerName = null;
                ip = channelContext.getClientNode().getIp();
            }
            if (ip.contains(",")) {
                if (log.isInfoEnabled()) {
                    log.info("ip[{}], header name:{}", (Object)ip, (Object)headerName);
                }
                ip = ip.split(",")[0].trim();
            }
            return ip;
        }
        return channelContext.getClientNode().getIp();
    }

    public static boolean isIp(String str) {
        if (str == null || str.length() < 7 || str.length() > 15) {
            return false;
        }
        Matcher mat = IP_PATTERN.matcher(str);
        return mat.find();
    }
}

