/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.HttpResponseStatus;
import org.tio.server.intf.TioServerHandler;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.mica.DigestUtils;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.common.WsServerDecoder;
import org.tio.websocket.common.WsServerEncoder;
import org.tio.websocket.common.WsSessionContext;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsTioServerHandler
implements TioServerHandler {
    private static final Logger log = LoggerFactory.getLogger(WsTioServerHandler.class);
    private static final String NOT_FINAL_WEBSOCKET_PACKET_PARTS = "TIO_N_F_W_P_P";
    private static final String SEC_WEBSOCKET_KEY_SUFFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final byte[] SEC_WEBSOCKET_KEY_SUFFIX_BYTES = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes();
    private final IWsMsgHandler wsMsgHandler;
    private final HttpConfig wsServerConfig;

    public WsTioServerHandler(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
    }

    private static String selectSubProtocol(String requestedSubProtocols, String[] subProtocols) {
        String[] requestedSubProtocolArray;
        if (requestedSubProtocols == null || subProtocols == null || subProtocols.length == 0) {
            return null;
        }
        for (String p : requestedSubProtocolArray = requestedSubProtocols.split(",")) {
            String requestedSubProtocol = p.trim();
            for (String supportedSubProtocol : subProtocols) {
                if (!requestedSubProtocol.equals(supportedSubProtocol)) continue;
                return requestedSubProtocol;
            }
        }
        return null;
    }

    public WsRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        WsSessionContext wsSessionContext = (WsSessionContext)channelContext.get("TIO_W_S_C");
        if (!wsSessionContext.isHandshaked()) {
            HttpRequest request = HttpRequestDecoder.decode(buffer, limit, position, readableLength, channelContext, this.wsServerConfig);
            if (request == null) {
                return null;
            }
            HttpResponse httpResponse = this.updateWebSocketProtocol(request);
            if (httpResponse == null) {
                throw new TioDecodeException("http\u534f\u8bae\u5347\u7ea7\u5230websocket\u534f\u8bae\u5931\u8d25");
            }
            wsSessionContext.setHandshakeRequest(request);
            wsSessionContext.setHandshakeResponse(httpResponse);
            WsRequest wsRequestPacket = new WsRequest();
            wsRequestPacket.setHandShake(true);
            return wsRequestPacket;
        }
        WsRequest websocketPacket = WsServerDecoder.decode(buffer, channelContext);
        if (websocketPacket != null) {
            if (!websocketPacket.isWsEof()) {
                ArrayList<WsRequest> parts = (ArrayList<WsRequest>)channelContext.get(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts == null) {
                    parts = new ArrayList<WsRequest>();
                    channelContext.set(NOT_FINAL_WEBSOCKET_PACKET_PARTS, parts);
                }
                parts.add(websocketPacket);
            } else {
                byte[] bodyBs;
                List parts = (List)channelContext.get(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts != null) {
                    channelContext.set(NOT_FINAL_WEBSOCKET_PACKET_PARTS, null);
                    parts.add(websocketPacket);
                    WsRequest first = (WsRequest)((Object)parts.get(0));
                    websocketPacket.setWsOpcode(first.getWsOpcode());
                    int allBodyLength = 0;
                    for (WsRequest wsRequest : parts) {
                        allBodyLength += wsRequest.getBody().length;
                    }
                    byte[] allBody = new byte[allBodyLength];
                    int index = 0;
                    for (WsRequest wsRequest : parts) {
                        System.arraycopy(wsRequest.getBody(), 0, allBody, index, wsRequest.getBody().length);
                        index += wsRequest.getBody().length;
                    }
                    websocketPacket.setBody(allBody);
                }
                HttpRequest handshakeRequest = wsSessionContext.getHandshakeRequest();
                if (websocketPacket.getWsOpcode() != Opcode.BINARY && (bodyBs = websocketPacket.getBody()) != null) {
                    String text = new String(bodyBs, handshakeRequest.getCharset());
                    websocketPacket.setWsBodyText(text);
                }
            }
        }
        return websocketPacket;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        WsResponse wsResponse;
        if (packet instanceof WsResponse) {
            wsResponse = (WsResponse)packet;
        } else {
            wsResponse = this.wsMsgHandler.encodeSubProtocol(packet, tioConfig, channelContext);
            Objects.requireNonNull(wsResponse, "IWsMsgHandler encodeSubProtocol WsResponse is null.");
        }
        if (wsResponse.isHandShake()) {
            WsSessionContext imSessionContext = (WsSessionContext)channelContext.get("TIO_W_S_C");
            HttpResponse handshakeResponse = imSessionContext.getHandshakeResponse();
            return HttpResponseEncoder.encode(handshakeResponse, tioConfig, channelContext);
        }
        return WsServerEncoder.encode(wsResponse);
    }

    public HttpConfig getHttpConfig() {
        return this.wsServerConfig;
    }

    private WsResponse h(WsRequest websocketPacket, byte[] bytes, Opcode opcode, ChannelContext channelContext) throws Exception {
        if (opcode == Opcode.TEXT) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            String text = new String(bytes, this.wsServerConfig.getCharset());
            Object retObj = this.wsMsgHandler.onText(websocketPacket, text, channelContext);
            String methodName = "onText";
            WsResponse wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.BINARY) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            Object retObj = this.wsMsgHandler.onBytes(websocketPacket, bytes, channelContext);
            String methodName = "onBytes";
            WsResponse wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.PING || opcode == Opcode.PONG) {
            log.debug("\u6536\u5230:{}", (Object)opcode);
            return null;
        }
        if (opcode == Opcode.CLOSE) {
            Object retObj = this.wsMsgHandler.onClose(websocketPacket, bytes, channelContext);
            String methodName = "onClose";
            WsResponse wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        Tio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0c\u9519\u8bef\u7684Opcode");
        return null;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        WsRequest wsRequest = (WsRequest)packet;
        if (wsRequest.isHandShake()) {
            HttpResponse httpResponse;
            WsSessionContext wsSessionContext = (WsSessionContext)channelContext.get("TIO_W_S_C");
            HttpRequest request = wsSessionContext.getHandshakeRequest();
            HttpResponse r = this.wsMsgHandler.handshake(request, httpResponse = wsSessionContext.getHandshakeResponse(), channelContext);
            if (r == null) {
                Tio.remove((ChannelContext)channelContext, (String)"\u4e1a\u52a1\u5c42\u4e0d\u540c\u610f\u63e1\u624b");
                return;
            }
            wsSessionContext.setHandshakeResponse(r);
            WsResponse wsResponse = new WsResponse();
            wsResponse.setHandShake(true);
            Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
            wsSessionContext.setHandshaked(true);
            this.wsMsgHandler.onAfterHandshaked(request, httpResponse, channelContext);
            return;
        }
        if (!wsRequest.isWsEof()) {
            return;
        }
        WsResponse wsResponse = this.h(wsRequest, wsRequest.getBody(), wsRequest.getWsOpcode(), channelContext);
        if (wsResponse != null) {
            Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
        }
    }

    private WsResponse processRetObj(Object obj, String methodName, ChannelContext channelContext) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            WsResponse wsResponse = WsResponse.fromText(str, this.wsServerConfig.getCharset());
            return wsResponse;
        }
        if (obj instanceof byte[]) {
            WsResponse wsResponse = WsResponse.fromBytes((byte[])obj);
            return wsResponse;
        }
        if (obj instanceof WsResponse) {
            return (WsResponse)((Object)obj);
        }
        if (obj instanceof ByteBuffer) {
            byte[] bs = ((ByteBuffer)obj).array();
            WsResponse wsResponse = WsResponse.fromBytes(bs);
            return wsResponse;
        }
        log.error("{} {}.{}()\u65b9\u6cd5\uff0c\u53ea\u5141\u8bb8\u8fd4\u56debyte[]\u3001ByteBuffer\u3001WsResponse\u6216null\uff0c\u4f46\u662f\u7a0b\u5e8f\u8fd4\u56de\u4e86{}", new Object[]{channelContext, this.getClass().getName(), methodName, obj.getClass().getName()});
        return null;
    }

    public HttpResponse updateWebSocketProtocol(HttpRequest request) {
        Map<String, String> headers = request.getHeaders();
        String secWebSocketKey = headers.get("sec-websocket-key");
        if (StrUtil.isNotBlank((CharSequence)secWebSocketKey)) {
            String requestedSubProtocols;
            String selectSubProtocol;
            byte[] secWebSocketKeyBytes = secWebSocketKey.getBytes(request.getCharset());
            byte[] allBs = new byte[secWebSocketKeyBytes.length + SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length];
            System.arraycopy(secWebSocketKeyBytes, 0, allBs, 0, secWebSocketKeyBytes.length);
            System.arraycopy(SEC_WEBSOCKET_KEY_SUFFIX_BYTES, 0, allBs, secWebSocketKeyBytes.length, SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length);
            byte[] keyArray = DigestUtils.sha1((byte[])allBs);
            String acceptKey = Base64.getEncoder().encodeToString(keyArray);
            HttpResponse httpResponse = new HttpResponse(request);
            httpResponse.setStatus(HttpResponseStatus.C101);
            HashMap<HeaderName, HeaderValue> respHeaders = new HashMap<HeaderName, HeaderValue>();
            respHeaders.put(HeaderName.Connection, HeaderValue.Connection.Upgrade);
            respHeaders.put(HeaderName.Upgrade, HeaderValue.Upgrade.WebSocket);
            respHeaders.put(HeaderName.Sec_WebSocket_Accept, HeaderValue.from(acceptKey));
            String[] supportedSubProtocols = this.wsMsgHandler.getSupportedSubProtocols();
            if (supportedSubProtocols != null && supportedSubProtocols.length > 0 && (selectSubProtocol = WsTioServerHandler.selectSubProtocol(requestedSubProtocols = headers.get("sec-websocket-protocol"), supportedSubProtocols)) != null) {
                respHeaders.put(HeaderName.Sec_Websocket_Protocol, HeaderValue.from(selectSubProtocol));
            }
            httpResponse.addHeaders(respHeaders);
            return httpResponse;
        }
        return null;
    }
}

