/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/

	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

	1. Definitions.

	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.

	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.

	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.

	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.

	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.

	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.

	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).

	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.

	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."

	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.

	2. Grant of Copyright License.

	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.

	3. Grant of Patent License.

	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.

	4. Redistribution.

	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:

	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.

	5. Submission of Contributions.

	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.

	6. Trademarks.

	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.

	7. Disclaimer of Warranty.

	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.

	8. Limitation of Liability.

	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.

	9. Accepting Warranty or Additional Liability.

	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.

	END OF TERMS AND CONDITIONS

	APPENDIX: How to apply the Apache License to your work

	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.

	   Copyright 2020 t-io

	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at

	     http://www.apache.org/licenses/LICENSE-2.0

	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.http.common;

import org.tio.utils.SysConst;

import java.nio.charset.Charset;

/**
 * @author tanyaowu
 */
public interface HttpConst {

	/**
	 * 服务信息
	 */
	String SERVER_INFO = "mica-net";
	/**
	 * 默认的字符集
	 */
	Charset CHARSET = SysConst.DEFAULT_CHARSET;

	/**
	 * 请求体的格式
	 *
	 * @author tanyaowu
	 * 2017年6月28日 上午10:03:12
	 */
	enum RequestBodyFormat {
		/**
		 * 请求内容格式
		 */
		URLENCODED, MULTIPART, TEXT
	}

	interface HttpVersion {
		String V1_1 = "1.1";
		String V1_0 = "1.0";
	}

	/**
	 * Accept-Language : zh-CN,zh;q=0.8
	 * Sec-WebSocket-Version : 13
	 * Sec-WebSocket-Extensions : permessage-deflate; client_max_window_bits
	 * Upgrade : websocket
	 * Host : t-io.org:9321
	 * Accept-Encoding : gzip, deflate, sdch
	 * User-Agent : Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36
	 * Origin : http://www.t-io.org:9292
	 * Sec-WebSocket-Key : kmCL2C7q9vtNSMyHpft7lw==
	 * Connection : Upgrade
	 * Cache-Control : no-cache
	 * Pragma : no-cache
	 *
	 * @author tanyaowu
	 * 2017年5月27日 下午2:11:57
	 */
	interface RequestHeaderKey {
		String Cookie = "cookie";                        //.toLowerCase();//Cookie: $Version=1; Skin=new;
		String Origin = "origin";                        //.toLowerCase(); //http://127.0.0.1
		String Sec_WebSocket_Key = "sec-websocket-key";            //.toLowerCase(); //2GFwqJ1Z37glm62YKKLUeA==
		String Cache_Control = "cache-control";                //.toLowerCase(); //"public, max-age:86400"
		String Connection = "connection";                    //.toLowerCase(); //Upgrade,  keep-alive
		String User_Agent = "user-agent";                    //.toLowerCase(); //Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3088.3 Safari/537.36
		String Sec_WebSocket_Version = "sec-websocket-version";        //.toLowerCase(); //13
		String Host = "host";                        //.toLowerCase(); //127.0.0.1:9321
		String Pragma = "pragma";                        //.toLowerCase(); //no-cache
		String Accept_Encoding = "accept-encoding";            //.toLowerCase(); //gzip, deflate, br
		String Accept_Language = "accept-language";            //.toLowerCase(); //zh-CN,zh;q=0.8,en;q=0.6
		String Upgrade = "upgrade";                    //.toLowerCase(); //websocket
		String Sec_WebSocket_Extensions = "sec-websocket-extensions";    //.toLowerCase(); //permessage-deflate; client_max_window_bits
		String Content_Length = "content-length";                //.toLowerCase(); //65
		String Content_Type = "content-type";                //.toLowerCase();// : 【application/x-www-form-urlencoded】【application/x-www-form-urlencoded; charset=UTF-8】【multipart/form-data; boundary=----WebKitFormBoundaryuwYcfA2AIgxqIxA0 】
		String If_Modified_Since = "if-modified-since";            //.toLowerCase(); //与Last-Modified配合

		String Referer = "referer";

		/**
		 * 值为XMLHttpRequest则为Ajax
		 */
		String X_Requested_With = "x-requested-with";//.toLowerCase();//XMLHttpRequest

		String Sec_Websocket_Protocol = "sec-websocket-protocol";        //.toLowerCase(); // websocket 子协议
	}

	/**
	 * @author tanyaowu
	 * 2017年6月27日 下午8:23:58
	 */
	interface RequestHeaderValue {
		interface Connection {
			String keep_alive = "keep-alive";    //.toLowerCase();
			String Upgrade = "upgrade";    //.toLowerCase();
			String close = "close";        //.toLowerCase();
		}

		//application/x-www-form-urlencoded、multipart/form-data、text/plain
		interface Content_Type {
			/**
			 * 普通文本，一般会是json或是xml
			 */
			String text_plain = "text/plain";
			/**
			 * 文件上传
			 */
			String multipart_form_data = "multipart/form-data";
			/**
			 * 普通的key-value
			 */
			String application_x_www_form_urlencoded = "application/x-www-form-urlencoded";
		}
	}

	interface ResponseHeaderKey {
		//Set-Cookie: UserID=JohnDoe; Max-Age=3600; Version=1
		String Set_Cookie = "Set-Cookie".toLowerCase();                        //Set-Cookie: UserID=JohnDoe; Max-Age=3600; Version=1
		String Content_Length = "Content-Length".toLowerCase();                    //65
		String Cache_Control = "Cache-Control".toLowerCase();                    //"public, max-age:86400"
		String Connection = "Connection".toLowerCase();                        //Upgrade,  keep-alive
		String Keep_Alive = "Keep-Alive".toLowerCase();                        //Keep-Alive:timeout=20
		String Sec_WebSocket_Accept = "Sec-WebSocket-Accept".toLowerCase();
		String Upgrade = "Upgrade".toLowerCase();
		String Access_Control_Allow_Credentials = "Access-Control-Allow-Credentials".toLowerCase();

		/**
		 * Content-Disposition: attachment;filename=FileName.txt
		 * 文件下载
		 */
		String Content_Disposition = "Content-Disposition".toLowerCase();
		/**
		 * 文档的编码（Encode）方法。只有在解码之后才可以得到Content-Type头指定的内容类型。
		 * 利用gzip压缩文档能够显著地减少HTML文档的下载时间。
		 * Java的GZIPOutputStream可以很方便地进行gzip压缩，但只有Unix上的Netscape和Windows上的IE 4、IE 5才支持它。
		 * 因此，Servlet应该通过查看Accept-Encoding头（即request.getHeader("Accept-Encoding")）检查浏览器是否支持gzip，
		 * 为支持gzip的浏览器返回经gzip压缩的HTML页面，为其他浏览器返回普通页面。
		 */
		String Content_Encoding = "Content-Encoding".toLowerCase();
		/**
		 * 表示后面的文档属于什么MIME类型。Servlet默认为text/plain，但通常需要显式地指定为text/html。
		 * 由于经常要设置Content-Type，因此HttpServletResponse提供了一个专用的方法setContentType。
		 */
		String Content_Type = "Content-Type".toLowerCase();
		/**
		 * 当前的GMT时间。你可以用setDateHeader来设置这个头以避免转换时间格式的麻烦。
		 */
		String Date = "Date".toLowerCase();
		/**
		 * 应该在什么时候认为文档已经过期，从而不再缓存它？
		 */
		String Expires = "Expires".toLowerCase();
		/**
		 * 文档的最后改动时间。客户可以通过If-Modified-Since请求头提供一个日期，该请求将被视为一个条件GET，
		 * 只有改动时间迟于指定时间的文档才会返回，否则返回一个304（Not Modified）状态。Last-Modified也可用setDateHeader方法来设置。
		 */
		String Last_Modified = "Last-Modified".toLowerCase();
		/**
		 * 表示客户应当到哪里去提取文档。Location通常不是直接设置的，而是通过HttpServletResponse的sendRedirect方法，该方法同时设置状态代码为302。
		 */
		String Location = "Location".toLowerCase();
		/**
		 * 表示浏览器应该在多少时间之后刷新文档，以秒计。除了刷新当前文档之外，你还可以通过setHeader("Refresh", "5; URL=http://host/path")让浏览器读取指定的页面。
		 * 注意这种功能通常是通过设置HTML页面HEAD区的＜META HTTP-EQUIV="Refresh" CONTENT="5;URL=http://host/path"＞实现，这是因为，自动刷新或重定向对于那些不能使用CGI或Servlet的HTML编写者十分重要。但是，对于Servlet来说，直接设置Refresh头更加方便。
		 * <p>
		 * 注意Refresh的意义是"N秒之后刷新本页面或访问指定页面"，而不是"每隔N秒刷新本页面或访问指定页面"。因此，连续刷新要求每次都发送一个Refresh头，而发送204状态代码则可以阻止浏览器继续刷新，不管是使用Refresh头还是＜META HTTP-EQUIV="Refresh" ...＞。
		 * <p>
		 * 注意Refresh头不属于HTTP 1.1正式规范的一部分，而是一个扩展，但Netscape和IE都支持它。
		 */
		String Refresh = "Refresh".toLowerCase();
		/**
		 * 服务器名字。Servlet一般不设置这个值，而是由Web服务器自己设置。
		 */
		String Server = "Server".toLowerCase();

		/**
		 *
		 */
		String Access_Control_Allow_Origin = "Access-Control-Allow-Origin".toLowerCase(); //value: *

		String Access_Control_Allow_Methods = "Access-Control-Allow-Methods".toLowerCase();

		String Access_Control_Max_Age = "Access-Control-Max-Age".toLowerCase();
		/**
		 *
		 */
		String Access_Control_Allow_Headers = "Access-Control-Allow-Headers".toLowerCase();    //.toLowerCase(); //value: x-requested-with,content-type

		/**
		 * 是否是从缓存中获取的数据，tio-httpserver特有的头部信息
		 */
		String tio_from_cache = "tio-from-cache";

		/**
		 *
		 */
		String tio_webpack_used_cache = "tio-webpack-used-cache";

	}

	/**
	 * @author tanyaowu
	 * 2017年6月27日 下午8:24:02
	 */
	interface ResponseHeaderValue {
		interface Connection {
			String keep_alive = "keep-alive";
			String Upgrade = "Upgrade";
			String close = "close";
		}

		interface Upgrade {
			String WebSocket = "WebSocket";
		}
	}
}
