/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.tio.core.intf.TioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpUuid;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.server.HttpTioServerHandler;
import org.tio.http.server.HttpTioServerListener;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.Threads;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class HttpServerStarter {
    private HttpConfig httpConfig = null;
    private HttpTioServerHandler httpTioServerHandler = null;
    private HttpTioServerListener httpTioServerListener = null;
    private TioServerConfig tioServerConfig = null;
    private TioServer tioServer = null;
    private HttpRequestHandler httpRequestHandler = null;

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this(httpConfig, requestHandler, null, null);
    }

    public HttpServerStarter(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        if (tioExecutor == null) {
            tioExecutor = Threads.getTioExecutor();
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.getGroupExecutor();
        }
        this.init(httpConfig, requestHandler, tioExecutor, groupExecutor);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public void setHttpRequestHandler(HttpRequestHandler requestHandler) {
        this.httpRequestHandler = requestHandler;
    }

    public HttpTioServerHandler getHttpTioServerHandler() {
        return this.httpTioServerHandler;
    }

    public HttpTioServerListener getHttpTioServerListener() {
        return this.httpTioServerListener;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    private void init(HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        String systemTimerPeriod = System.getProperty("tio.system.timer.period");
        if (StrUtil.isBlank((CharSequence)systemTimerPeriod)) {
            System.setProperty("tio.system.timer.period", "50");
        }
        this.httpConfig = httpConfig;
        this.httpRequestHandler = requestHandler;
        httpConfig.setHttpRequestHandler(this.httpRequestHandler);
        this.httpTioServerHandler = new HttpTioServerHandler(httpConfig, requestHandler);
        this.httpTioServerListener = new HttpTioServerListener();
        String name = httpConfig.getName();
        if (StrUtil.isBlank((CharSequence)name)) {
            name = "Tio Http Server";
        }
        this.tioServerConfig = new TioServerConfig(name, (TioServerHandler)this.httpTioServerHandler, (TioServerListener)this.httpTioServerListener, tioExecutor, groupExecutor);
        this.tioServerConfig.setHeartbeatTimeout(20000L);
        this.tioServerConfig.setShortConnection(true);
        this.tioServerConfig.setReadBufferSize(132476);
        this.tioServerConfig.set("TIO_HTTP_REQ_HANDLER", (Object)this.httpRequestHandler);
        this.tioServer = new TioServer(this.tioServerConfig);
        HttpUuid imTioUuid = new HttpUuid();
        this.tioServerConfig.setTioUuid((TioUuid)imTioUuid);
    }

    public void start() throws IOException {
        this.tioServer.start(this.httpConfig.getBindIp(), this.httpConfig.getBindPort());
    }

    public void stop() {
        this.tioServer.stop();
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }
}

