/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsPacket;

public class WsResponse
extends WsPacket {
    private static final long serialVersionUID = 963847148301021559L;
    private static final Logger log = LoggerFactory.getLogger(WsResponse.class);

    public static WsResponse fromText(String text, String charset) {
        WsResponse wsResponse = new WsResponse();
        try {
            wsResponse.setBody(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        wsResponse.setWsOpcode(Opcode.TEXT);
        return wsResponse;
    }

    public static WsResponse fromBytes(byte[] bytes) {
        WsResponse wsResponse = new WsResponse();
        wsResponse.setBody(bytes);
        wsResponse.setWsOpcode(Opcode.BINARY);
        return wsResponse;
    }
}

