/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.server.intf.TioServerHandler;

public class HttpTioServerHandler
implements TioServerHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpTioServerHandler.class);
    public static final String REQUEST_KEY = "tio_request_key";
    protected final HttpConfig httpConfig;
    private final HttpRequestHandler requestHandler;

    public HttpTioServerHandler(HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this.httpConfig = httpConfig;
        this.requestHandler = requestHandler;
    }

    public HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        HttpRequest request = HttpRequestDecoder.decode(buffer, limit, position, readableLength, channelContext, this.httpConfig);
        if (request != null) {
            channelContext.setAttribute(REQUEST_KEY, (Object)request);
        }
        return request;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        HttpResponse httpResponse = (HttpResponse)packet;
        try {
            ByteBuffer byteBuffer = HttpResponseEncoder.encode(httpResponse, tioConfig, channelContext);
            return byteBuffer;
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        HttpRequest request = (HttpRequest)packet;
        String ip = request.getClientIp();
        if (channelContext.tioConfig.ipBlacklist.isInBlacklist(ip)) {
            HttpResponse httpResponse = request.httpConfig.getRespForBlackIp();
            if (httpResponse != null) {
                Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
            } else {
                Tio.remove((ChannelContext)channelContext, (String)(ip + "\u5728\u9ed1\u540d\u5355\u4e2d"));
            }
            return;
        }
        HttpResponse httpResponse = this.requestHandler.handler(request);
        if (httpResponse != null) {
            Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
        } else {
            if (log.isInfoEnabled()) {
                log.info("{}, {}, handler return null, request line: {}", new Object[]{channelContext.tioConfig.getName(), channelContext, request.getRequestLine()});
            }
            request.close("handler return null");
        }
    }
}

