/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.http.common.Cookie;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpPacket;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.RequestLine;
import org.tio.http.common.UploadFile;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.StrUtil;

public class HttpRequest
extends HttpPacket {
    private static final long serialVersionUID = -3849253977016967211L;
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    public RequestLine requestLine = null;
    public ChannelContext channelContext;
    public HttpConfig httpConfig;
    protected Map<String, String> headers = new HashMap<String, String>();
    private boolean needForward = false;
    private boolean isForward = false;
    private Map<String, Object[]> params = new HashMap<String, Object[]>();
    private List<Cookie> cookies = null;
    private Map<String, Cookie> cookieMap = null;
    private int contentLength;
    private String connection;
    private String bodyString;
    private HttpConst.RequestBodyFormat bodyFormat;
    private String charset = "utf-8";
    private Boolean isAjax = null;
    private Boolean isSupportGzip = null;
    private Node remote = null;
    private String domain = null;
    private String host = null;
    private long createTime = SystemTimer.currTime;
    private boolean closed = false;
    private Integer forwardCount = null;

    public HttpRequest(Node remote) {
        this.remote = remote;
    }

    public HttpRequest() {
    }

    public void close() {
        this.close(null);
    }

    public void close(String remark) {
        this.closed = true;
        Tio.remove((ChannelContext)this.channelContext, (String)remark);
    }

    public void addParam(String key, Object value) {
        if (value == null) {
            return;
        }
        Object[] existValue = this.params.get(key);
        if (existValue != null) {
            Object[] newExistValue = new Object[existValue.length + 1];
            if (value instanceof String) {
                newExistValue = new String[existValue.length + 1];
            } else if (value instanceof UploadFile) {
                newExistValue = new UploadFile[existValue.length + 1];
            }
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = value;
            this.params.put(key, newExistValue);
        } else {
            Object[] newExistValue = null;
            if (value instanceof String) {
                newExistValue = new String[]{(String)value};
            } else if (value instanceof UploadFile) {
                newExistValue = new UploadFile[]{(UploadFile)value};
            }
            this.params.put(key, newExistValue);
        }
    }

    public HttpResponse forward(String newPath) throws Exception {
        if (StrUtil.contains((CharSequence)newPath, (char)'?')) {
            this.requestLine.path = StrUtil.subBefore((CharSequence)newPath, (CharSequence)"?", (boolean)false);
            this.requestLine.queryString = StrUtil.subAfter((CharSequence)newPath, (CharSequence)"?", (boolean)false);
        } else {
            this.requestLine.path = newPath;
            this.requestLine.queryString = null;
        }
        if (this.forwardCount == null) {
            this.forwardCount = 1;
        } else {
            Integer n = this.forwardCount;
            Integer n2 = this.forwardCount = Integer.valueOf(this.forwardCount + 1);
        }
        if (this.forwardCount > this.httpConfig.maxForwardCount) {
            log.error("forwardCount[{}] is too large, newPath:{}", (Object)this.forwardCount, (Object)newPath);
            this.close();
            return null;
        }
        this.needForward = true;
        return HttpResponse.NULL_RESPONSE;
    }

    public HttpConst.RequestBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setBodyFormat(HttpConst.RequestBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public String getUserAgent() {
        return this.headers.get("user-agent");
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = this.headers.get("host");
        return this.host;
    }

    public String getClientIp() {
        return this.remote.getIp();
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers != null) {
            Set<Map.Entry<String, String>> set = headers.entrySet();
            for (Map.Entry<String, String> entry : set) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        if (StrUtil.isBlank((CharSequence)this.getHost())) {
            return null;
        }
        this.domain = StrUtil.subBefore((CharSequence)this.getHost(), (CharSequence)":", (boolean)false);
        return this.domain;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public void setBodyString(String bodyString) {
        this.bodyString = bodyString;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Cookie getCookie(String name) {
        if (this.cookieMap == null) {
            return null;
        }
        return this.cookieMap.get(name);
    }

    public Map<String, Cookie> getCookieMap() {
        return this.cookieMap;
    }

    public void setCookieMap(Map<String, Cookie> cookieMap) {
        this.cookieMap = cookieMap;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        if (headers != null) {
            this.parseCookie(this.httpConfig);
        }
    }

    public void removeHeader(String key, String value) {
        this.headers.remove(key);
    }

    public Boolean getIsAjax() {
        if (this.isAjax == null) {
            String X_Requested_With = this.getHeader("x-requested-with");
            this.isAjax = X_Requested_With != null && "XMLHttpRequest".equalsIgnoreCase(X_Requested_With) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isAjax;
    }

    public void setIsAjax(Boolean isAjax) {
        this.isAjax = isAjax;
    }

    public Boolean getIsSupportGzip() {
        return true;
    }

    public void setIsSupportGzip(Boolean isSupportGzip) {
        this.isSupportGzip = isSupportGzip;
    }

    public Map<String, Object[]> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object[]> params) {
        this.params = params;
    }

    public Map<String, Object> getParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getParams() != null) {
            for (Map.Entry<String, Object[]> entry : this.params.entrySet()) {
                Object[] param = entry.getValue();
                if (param == null || param.length < 1) continue;
                String key = entry.getKey();
                params.put(key, param[0]);
            }
        }
        return params;
    }

    public Object getObject(String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        Object[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getParam(String name) {
        return (String)this.getObject(name);
    }

    public String getString(String name) {
        return this.getParam(name);
    }

    public UploadFile getUploadFile(String name) {
        Object[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            Object obj = values[0];
            return (UploadFile)obj;
        }
        return null;
    }

    public Integer getInt(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Short getShort(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Short.parseShort(value);
    }

    public Byte getByte(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Byte.parseByte(value);
    }

    public Long getLong(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Long.parseLong(value);
    }

    public Double getDouble(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public Float getFloat(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public Object[] getParamArray(String name) {
        return this.params.get(name);
    }

    public Node getRemote() {
        return this.remote;
    }

    public void setRemote(Node remote) {
        this.remote = remote;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public String logstr() {
        String str = "\r\n\u8bf7\u6c42ID_" + this.getId() + "\r\n" + this.getHeaderString();
        if (null != this.getBodyString()) {
            str = str + this.getBodyString();
        }
        return str;
    }

    public void parseCookie(HttpConfig httpConfig) {
        String cookieline = this.headers.get("cookie");
        if (StrUtil.isNotBlank((CharSequence)cookieline)) {
            this.cookies = new ArrayList<Cookie>();
            this.cookieMap = new HashMap<String, Cookie>();
            Map<String, String> _cookiemap = Cookie.getEqualMap(cookieline);
            Set<Map.Entry<String, String>> set = _cookiemap.entrySet();
            ArrayList<HashMap<String, String>> cookieListMap = new ArrayList<HashMap<String, String>>();
            for (Map.Entry<String, String> cookieMapEntry : set) {
                HashMap<String, String> cookieOneMap = new HashMap<String, String>();
                cookieOneMap.put(cookieMapEntry.getKey(), cookieMapEntry.getValue());
                cookieListMap.add(cookieOneMap);
                Cookie cookie = Cookie.buildCookie(cookieOneMap, httpConfig);
                this.cookies.add(cookie);
                this.cookieMap.put(cookie.getName(), cookie);
            }
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requestLine.toString()).append("\r\n");
        if (this.getHeaderString() != null) {
            sb.append(this.getHeaderString()).append("\r\n");
        }
        if (this.getBodyString() != null) {
            sb.append(this.getBodyString());
        }
        return sb.toString();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getReferer() {
        return this.getHeader("referer");
    }

    public boolean isNeedForward() {
        return this.needForward;
    }

    public void setNeedForward(boolean needForward) {
        this.needForward = needForward;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean isForward) {
        this.isForward = isForward;
    }
}

