/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.event;

import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.model.ClientInfo;
import net.dreamlu.iot.mqtt.spring.server.event.MqttClientOfflineEvent;
import net.dreamlu.iot.mqtt.spring.server.event.MqttClientOnlineEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.tio.core.ChannelContext;

public class SpringEventMqttConnectStatusListener
implements IMqttConnectStatusListener {
    private static final Logger log = LoggerFactory.getLogger(SpringEventMqttConnectStatusListener.class);
    private final ApplicationEventPublisher eventPublisher;
    private final MqttServerCreator serverCreator;

    public void online(ChannelContext context, String clientId, String username) {
        log.info("Mqtt clientId:{} username:{} online.", (Object)clientId, (Object)username);
        ClientInfo onlineEvent = ClientInfo.form((MqttServerCreator)this.serverCreator, (ChannelContext)context, MqttClientOnlineEvent::new);
        this.eventPublisher.publishEvent((Object)onlineEvent);
    }

    public void offline(ChannelContext context, String clientId, String username, String reason) {
        log.info("Mqtt clientId:{} username:{} offline reason:{}.", new Object[]{clientId, username, reason});
        MqttClientOfflineEvent offlineEvent = new MqttClientOfflineEvent();
        offlineEvent.setClientId(clientId);
        offlineEvent.setUsername(username);
        offlineEvent.setReason(reason);
        offlineEvent.setCloseAt(context.stat.timeClosed);
        this.eventPublisher.publishEvent((Object)offlineEvent);
    }

    public SpringEventMqttConnectStatusListener(ApplicationEventPublisher eventPublisher, MqttServerCreator serverCreator) {
        this.eventPublisher = eventPublisher;
        this.serverCreator = serverCreator;
    }
}

