/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.config;

import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.tio.core.ssl.ClientAuth;

@ConfigurationProperties(value="mqtt.server")
public class MqttServerProperties {
    public static final String PREFIX = "mqtt.server";
    private boolean enabled = true;
    private String name = "Mica-Mqtt-Server";
    private String ip;
    private int port = 1883;
    private MqttAuth auth = new MqttAuth();
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private DataSize readBufferSize = DataSize.ofBytes((long)8192L);
    private DataSize maxBytesInMessage = DataSize.ofBytes((long)0xA00000L);
    private Integer maxDecodeFailCount;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private Ssl ssl = new Ssl();
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private int webPort = 8083;
    private Ssl webSsl = new Ssl();
    private boolean websocketEnable = true;
    private boolean httpEnable = false;
    private HttpBasicAuth httpBasicAuth = new HttpBasicAuth();
    private String nodeName;
    private boolean statEnable = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public MqttAuth getAuth() {
        return this.auth;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public DataSize getReadBufferSize() {
        return this.readBufferSize;
    }

    public DataSize getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public Integer getMaxDecodeFailCount() {
        return this.maxDecodeFailCount;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public Ssl getWebSsl() {
        return this.webSsl;
    }

    public boolean isWebsocketEnable() {
        return this.websocketEnable;
    }

    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    public HttpBasicAuth getHttpBasicAuth() {
        return this.httpBasicAuth;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuth(MqttAuth auth) {
        this.auth = auth;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setKeepaliveBackoff(float keepaliveBackoff) {
        this.keepaliveBackoff = keepaliveBackoff;
    }

    public void setReadBufferSize(DataSize readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(DataSize maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setMaxDecodeFailCount(Integer maxDecodeFailCount) {
        this.maxDecodeFailCount = maxDecodeFailCount;
    }

    public void setBufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public void setWebSsl(Ssl webSsl) {
        this.webSsl = webSsl;
    }

    public void setWebsocketEnable(boolean websocketEnable) {
        this.websocketEnable = websocketEnable;
    }

    public void setHttpEnable(boolean httpEnable) {
        this.httpEnable = httpEnable;
    }

    public void setHttpBasicAuth(HttpBasicAuth httpBasicAuth) {
        this.httpBasicAuth = httpBasicAuth;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public static class MqttAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class HttpBasicAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Ssl {
        private boolean enabled = false;
        private String keystorePath;
        private String keystorePass;
        private String truststorePath;
        private String truststorePass;
        private ClientAuth clientAuth = ClientAuth.NONE;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public void setKeystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public void setTruststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}

