/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.config;

import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerPublishPermission;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerUniqueIdService;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttSessionListener;
import net.dreamlu.iot.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.server.store.IMqttMessageStore;
import net.dreamlu.iot.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.spring.server.MqttServerCustomizer;
import net.dreamlu.iot.mqtt.spring.server.MqttServerTemplate;
import net.dreamlu.iot.mqtt.spring.server.config.MqttServerLauncher;
import net.dreamlu.iot.mqtt.spring.server.config.MqttServerProperties;
import net.dreamlu.iot.mqtt.spring.server.event.SpringEventMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.spring.server.event.SpringEventMqttMessageListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttServerProperties.class})
public class MqttServerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IMqttConnectStatusListener springEventMqttConnectStatusListener(ApplicationEventPublisher eventPublisher, MqttServerCreator serverCreator) {
        return new SpringEventMqttConnectStatusListener(eventPublisher, serverCreator);
    }

    @Bean
    @ConditionalOnMissingBean
    public IMqttMessageListener springEventMqttMessageListener(ApplicationEventPublisher eventPublisher) {
        return new SpringEventMqttMessageListener(eventPublisher);
    }

    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties, ObjectProvider<IMqttServerAuthHandler> authHandlerObjectProvider, ObjectProvider<IMqttServerUniqueIdService> uniqueIdServiceObjectProvider, ObjectProvider<IMqttServerSubscribeValidator> subscribeValidatorObjectProvider, ObjectProvider<IMqttServerPublishPermission> publishPermissionObjectProvider, ObjectProvider<IMqttMessageDispatcher> messageDispatcherObjectProvider, ObjectProvider<IMqttMessageStore> messageStoreObjectProvider, ObjectProvider<IMqttSessionManager> sessionManagerObjectProvider, ObjectProvider<IMqttSessionListener> sessionListenerObjectProvider, ObjectProvider<IMqttMessageListener> messageListenerObjectProvider, ObjectProvider<IMqttConnectStatusListener> connectStatusListenerObjectProvider, ObjectProvider<IMqttMessageInterceptor> messageInterceptorObjectProvider, ObjectProvider<MqttServerCustomizer> customizers) {
        MqttServerProperties.Ssl webSsl;
        MqttServerProperties.Ssl ssl;
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).bufferAllocator(properties.getBufferAllocator()).maxClientIdLength(properties.getMaxClientIdLength()).maxDecodeFailCount(properties.getMaxDecodeFailCount()).webPort(properties.getWebPort()).websocketEnable(properties.isWebsocketEnable()).httpEnable(properties.isHttpEnable()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        MqttServerProperties.HttpBasicAuth httpBasicAuth = properties.getHttpBasicAuth();
        if (serverCreator.isHttpEnable() && httpBasicAuth.isEnable()) {
            serverCreator.httpBasicAuth(httpBasicAuth.getUsername(), httpBasicAuth.getPassword());
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            serverCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getKeystorePass(), ssl.getClientAuth());
        }
        if ((webSsl = properties.getWebSsl()).isEnabled()) {
            serverCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getKeystorePass(), webSsl.getClientAuth());
        }
        messageListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageListener(arg_0));
        IMqttServerAuthHandler authHandler = (IMqttServerAuthHandler)authHandlerObjectProvider.getIfAvailable(() -> {
            MqttServerProperties.MqttAuth mqttAuth = properties.getAuth();
            return mqttAuth.isEnable() ? new DefaultMqttServerAuthHandler(mqttAuth.getUsername(), mqttAuth.getPassword()) : null;
        });
        serverCreator.authHandler(authHandler);
        uniqueIdServiceObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).uniqueIdService(arg_0));
        subscribeValidatorObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).subscribeValidator(arg_0));
        publishPermissionObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).publishPermission(arg_0));
        messageDispatcherObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageDispatcher(arg_0));
        messageStoreObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageStore(arg_0));
        sessionManagerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionManager(arg_0));
        sessionListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionListener(arg_0));
        connectStatusListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).connectStatusListener(arg_0));
        messageInterceptorObjectProvider.orderedStream().forEach(arg_0 -> ((MqttServerCreator)serverCreator).addInterceptor(arg_0));
        customizers.ifAvailable(customizer -> customizer.customize(serverCreator));
        return serverCreator;
    }

    @Bean
    public MqttServer mqttServer(MqttServerCreator mqttServerCreator) {
        return mqttServerCreator.build();
    }

    @Bean
    public MqttServerLauncher mqttServerLauncher(MqttServer mqttServer) {
        return new MqttServerLauncher(mqttServer);
    }

    @Bean
    public MqttServerTemplate mqttServerTemplate(MqttServer mqttServer) {
        return new MqttServerTemplate(mqttServer);
    }
}

