/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server;

import java.nio.ByteBuffer;
import java.util.List;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.model.ClientInfo;
import org.tio.core.ChannelContext;
import org.tio.utils.page.Page;

public class MqttServerTemplate {
    private final MqttServer mqttServer;

    public boolean publish(String clientId, String topic, ByteBuffer payload) {
        return this.mqttServer.publish(clientId, topic, payload);
    }

    public boolean publish(String clientId, String topic, ByteBuffer payload, MqttQoS qos) {
        return this.mqttServer.publish(clientId, topic, payload, qos);
    }

    public boolean publish(String clientId, String topic, ByteBuffer payload, boolean retain) {
        return this.mqttServer.publish(clientId, topic, payload, retain);
    }

    public boolean publish(String clientId, String topic, ByteBuffer payload, MqttQoS qos, boolean retain) {
        return this.mqttServer.publish(clientId, topic, payload, qos, retain);
    }

    public boolean publishAll(String topic, ByteBuffer payload) {
        return this.mqttServer.publishAll(topic, payload);
    }

    public boolean publishAll(String topic, ByteBuffer payload, MqttQoS qos) {
        return this.mqttServer.publishAll(topic, payload, qos);
    }

    public boolean publishAll(String topic, ByteBuffer payload, boolean retain) {
        return this.mqttServer.publishAll(topic, payload, retain);
    }

    public boolean publishAll(String topic, ByteBuffer payload, MqttQoS qos, boolean retain) {
        return this.mqttServer.publishAll(topic, payload, qos, retain);
    }

    public boolean publishAll(String topic, byte[] payload) {
        return this.mqttServer.publishAll(topic, payload, MqttQoS.AT_MOST_ONCE);
    }

    public boolean publishAll(String topic, byte[] payload, MqttQoS qos) {
        return this.mqttServer.publishAll(topic, payload, qos, false);
    }

    public boolean publishAll(String topic, byte[] payload, boolean retain) {
        return this.mqttServer.publishAll(topic, payload, MqttQoS.AT_MOST_ONCE, retain);
    }

    public boolean publishAll(String topic, byte[] payload, MqttQoS qos, boolean retain) {
        return this.mqttServer.publishAll(topic, payload, qos, retain);
    }

    public List<ClientInfo> getClients() {
        return this.mqttServer.getClients();
    }

    public Page<ClientInfo> getClients(Integer pageIndex, Integer pageSize) {
        return this.mqttServer.getClients(pageIndex, pageSize);
    }

    public ChannelContext getChannelContext(String clientId) {
        return this.mqttServer.getChannelContext(clientId);
    }

    public boolean disconnect(String clientId) {
        return this.mqttServer.disconnect(clientId);
    }

    public void close(String clientId) {
        this.mqttServer.close(clientId);
    }

    public MqttServerTemplate(MqttServer mqttServer) {
        this.mqttServer = mqttServer;
    }
}

