/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.server.noear.config;

import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.server.noear.config.DataSize;
import net.dreamlu.iot.mqtt.server.noear.config.MqttServerProperties;
import net.dreamlu.iot.mqtt.server.noear.event.SolonEventMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.server.noear.event.SolonEventMqttMessageListener;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class MqttServerConfiguration {
    @Bean
    @Condition(onMissingBean=IMqttConnectStatusListener.class)
    public IMqttConnectStatusListener connectStatusListener() {
        return new SolonEventMqttConnectStatusListener();
    }

    @Bean
    @Condition(onMissingBean=IMqttMessageListener.class)
    public IMqttMessageListener messageListener() {
        return new SolonEventMqttMessageListener();
    }

    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties) {
        MqttServerProperties.Ssl ssl;
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize((int)DataSize.parse(properties.getReadBufferSize()).getBytes()).maxBytesInMessage((int)DataSize.parse(properties.getMaxBytesInMessage()).getBytes()).bufferAllocator(properties.getBufferAllocator()).maxClientIdLength(properties.getMaxClientIdLength()).webPort(properties.getWebPort()).websocketEnable(properties.isWebsocketEnable()).httpEnable(properties.isHttpEnable()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        MqttServerProperties.HttpBasicAuth httpBasicAuth = properties.getHttpBasicAuth();
        if (serverCreator.isHttpEnable() && httpBasicAuth.isEnable()) {
            serverCreator.httpBasicAuth(httpBasicAuth.getUsername(), httpBasicAuth.getPassword());
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            serverCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth());
        }
        return serverCreator;
    }
}

