/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client.event;

import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.spring.client.event.MqttConnectedEvent;
import net.dreamlu.iot.mqtt.spring.client.event.MqttDisconnectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.tio.core.ChannelContext;

public class SpringEventMqttClientConnectListener
implements IMqttClientConnectListener {
    private static final Logger log = LoggerFactory.getLogger(SpringEventMqttClientConnectListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public void onConnected(ChannelContext context, boolean isReconnect) {
        if (isReconnect) {
            log.info("\u91cd\u8fde mqtt \u670d\u52a1\u5668\u91cd\u8fde\u6210\u529f...");
        } else {
            log.info("\u8fde\u63a5 mqtt \u670d\u52a1\u5668\u6210\u529f...");
        }
        this.eventPublisher.publishEvent((Object)new MqttConnectedEvent(context, isReconnect));
    }

    public void onDisconnect(ChannelContext context, Throwable throwable, String remark, boolean isRemove) {
        String reason;
        if (throwable == null) {
            reason = remark;
            log.info("mqtt \u8fde\u63a5\u65ad\u5f00 remark:{} isRemove:{}", (Object)remark, (Object)isRemove);
        } else {
            reason = remark + " Exception:" + throwable.getMessage();
            log.error("mqtt \u8fde\u63a5\u65ad\u5f00 remark:{} isRemove:{}", new Object[]{remark, isRemove, throwable});
        }
        this.eventPublisher.publishEvent((Object)new MqttDisconnectEvent(context, reason, isRemove));
    }

    public SpringEventMqttClientConnectListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

