/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import net.dreamlu.iot.mqtt.codec.MqttTopicSubscription;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribeDetector;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribeLazyFilter;
import net.dreamlu.iot.mqtt.spring.client.MqttClientTemplate;
import net.dreamlu.iot.mqtt.spring.client.config.MqttClientProperties;
import net.dreamlu.iot.mqtt.spring.client.event.SpringEventMqttClientConnectListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.tio.core.ssl.SSLEngineCustomizer;
import org.tio.core.ssl.SslConfig;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttClientProperties.class})
public class MqttClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IMqttClientConnectListener springEventMqttClientConnectListener(ApplicationEventPublisher eventPublisher) {
        return new SpringEventMqttClientConnectListener(eventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MqttClientCreator mqttClientCreator(MqttClientProperties properties, ObjectProvider<SSLEngineCustomizer> sslCustomizers) {
        List<MqttTopicSubscription> globalSubscribe;
        MqttClientProperties.WillMessage willMessage;
        MqttClientProperties.Ssl ssl;
        MqttClientCreator clientCreator = MqttClient.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).username(properties.getUserName()).password(properties.getPassword()).clientId(properties.getClientId()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).maxClientIdLength(properties.getMaxClientIdLength()).keepAliveSecs(properties.getKeepAliveSecs()).reconnect(properties.isReconnect()).reInterval(properties.getReInterval()).retryCount(properties.getRetryCount()).reSubscribeBatchSize(properties.getReSubscribeBatchSize()).version(properties.getVersion()).cleanSession(properties.isCleanSession()).sessionExpiryIntervalSecs(Integer.valueOf(properties.getSessionExpiryIntervalSecs())).bufferAllocator(properties.getBufferAllocator()).statEnable(properties.isStatEnable()).debug(properties.isDebug()).bizThreadPoolSize(properties.getBizThreadPoolSize());
        Integer timeout = properties.getTimeout();
        if (timeout != null && timeout > 0) {
            clientCreator.timeout(timeout);
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            SslConfig sslConfig = SslConfig.forClient((String)ssl.getKeystorePath(), (String)ssl.getKeystorePass(), (String)ssl.getTruststorePath(), (String)ssl.getTruststorePass());
            clientCreator.sslConfig(sslConfig);
            sslCustomizers.ifAvailable(arg_0 -> ((SslConfig)sslConfig).setSslEngineCustomizer(arg_0));
        }
        if ((willMessage = properties.getWillMessage()) != null && StringUtils.hasText((String)willMessage.getTopic())) {
            clientCreator.willMessage(builder -> {
                builder.topic(willMessage.getTopic()).qos(willMessage.getQos()).retain(willMessage.isRetain());
                if (StringUtils.hasText((String)willMessage.getMessage())) {
                    builder.message(willMessage.getMessage().getBytes(StandardCharsets.UTF_8));
                }
            });
        }
        if ((globalSubscribe = properties.getGlobalSubscribe()) != null && !globalSubscribe.isEmpty()) {
            clientCreator.globalSubscribe(globalSubscribe);
        }
        return clientCreator;
    }

    @Bean(value={"mqttClientTemplate"})
    @ConditionalOnMissingBean(name={"mqttClientTemplate"})
    public MqttClientTemplate mqttClientTemplate(MqttClientCreator mqttClientCreator) {
        return new MqttClientTemplate(mqttClientCreator);
    }

    @Bean
    public static MqttClientSubscribeDetector mqttClientSubscribeDetector(ApplicationContext applicationContext) {
        return new MqttClientSubscribeDetector(applicationContext);
    }

    @Bean
    public MqttClientSubscribeLazyFilter mqttClientSubscribeLazyFilter() {
        return new MqttClientSubscribeLazyFilter();
    }
}

